/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.handler;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openvpms.component.business.service.archetype.handler.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigReader {
    private static final Logger log = LoggerFactory.getLogger(ConfigReader.class);

    public void read(String name) {
        Set<URL> paths = this.getPaths(name);
        for (URL path : paths) {
            this.read(path);
        }
    }

    protected Set<URL> getPaths(String name) {
        HashSet<URL> paths = new HashSet<URL>();
        for (ClassLoader loader : this.getClassLoaders()) {
            if (loader == null) continue;
            try {
                Enumeration<URL> urls = loader.getResources(name);
                while (urls.hasMoreElements()) {
                    paths.add(urls.nextElement());
                }
            }
            catch (IOException exception) {
                log.error("Failed to get resource " + name, (Throwable)exception);
            }
        }
        return paths;
    }

    protected abstract void read(URL var1);

    protected Class<?> getClass(String name, Class<?> type, String path) {
        for (ClassLoader loader : this.getClassLoaders()) {
            if (loader == null) continue;
            try {
                Class<?> clazz = loader.loadClass(name);
                if (type.isAssignableFrom(clazz)) {
                    return clazz;
                }
                log.error("Failed to load class: {}, specified in {}: does not extend {}", new Object[]{name, path, type.getName()});
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        log.error("Failed to load class: {}, specified in {}", (Object)name, (Object)path);
        return null;
    }

    protected ClassLoader[] getClassLoaders() {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        ClassLoader clazz = PropertiesReader.class.getClassLoader();
        if (context != null && context != clazz) {
            return new ClassLoader[]{context, clazz};
        }
        return new ClassLoader[]{clazz};
    }
}

