/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.functor;

import java.util.Objects;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.functor.RelationshipRef;

public class RefEquals
implements Predicate {
    private final IMObjectReference ref;
    private final Transformer transformer;

    public RefEquals(Entity entity, Transformer transformer) {
        this(entity != null ? entity.getObjectReference() : null, transformer);
    }

    public RefEquals(IMObjectReference reference, Transformer transformer) {
        this.ref = reference;
        this.transformer = transformer;
    }

    public boolean evaluate(Object object) {
        return Objects.equals(this.ref, this.transformer.transform(object));
    }

    public static Predicate getSourceEquals(Entity entity) {
        return new RefEquals(entity, (Transformer)RelationshipRef.SOURCE);
    }

    public static Predicate getSourceEquals(IMObjectReference reference) {
        return new RefEquals(reference, (Transformer)RelationshipRef.SOURCE);
    }

    public static Predicate getTargetEquals(Entity entity) {
        return new RefEquals(entity, (Transformer)RelationshipRef.TARGET);
    }

    public static Predicate getTargetEquals(IMObjectReference reference) {
        return new RefEquals(reference, (Transformer)RelationshipRef.TARGET);
    }
}

