/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.openvpms.component.business.service.archetype.assertion.ProperCaseRules;

public class LocaleProperCaseRules
implements ProperCaseRules {
    private final String baseName;
    private final Locale locale;
    private static final String BASE_NAME = "org.openvpms.component.business.service.archetype.assertion.propercase";

    public LocaleProperCaseRules() {
        this(Locale.getDefault());
    }

    public LocaleProperCaseRules(String baseName) {
        this(baseName, Locale.getDefault());
    }

    public LocaleProperCaseRules(Locale locale) {
        this(BASE_NAME, locale);
    }

    public LocaleProperCaseRules(String baseName, Locale locale) {
        this.baseName = baseName;
        this.locale = locale;
    }

    @Override
    public String[] getSpace() {
        return this.getStrings("space.");
    }

    @Override
    public String[] getSpaceBefore() {
        return this.getStrings("spaceBefore.");
    }

    @Override
    public String[] getSpaceAfter() {
        return this.getStrings("spaceAfter.");
    }

    @Override
    public String[] getStartsWith() {
        return this.getStrings("startsWith.");
    }

    @Override
    public String[] getContains() {
        return this.getStrings("contains.");
    }

    @Override
    public String[] getEndsWith() {
        return this.getStrings("endsWith.");
    }

    @Override
    public String[] getExceptions() {
        return this.getStrings("exceptions.");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private String[] getStrings(String prefix) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, this.locale);
        ArrayList<String> matches = new ArrayList<String>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            matches.add(key);
        }
        String[] result = new String[matches.size()];
        for (int i = 0; i < matches.size(); ++i) {
            result[i] = bundle.getString((String)matches.get(i));
        }
        return result;
    }
}

