/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

class Notifier {
    private final ArchetypeService service;
    private final boolean syncActive;
    private final PlatformTransactionManager transactionManager;
    private final Set<org.openvpms.component.model.object.IMObject> saved = new LinkedHashSet<org.openvpms.component.model.object.IMObject>();
    private final Set<org.openvpms.component.model.object.IMObject> removed = new LinkedHashSet<org.openvpms.component.model.object.IMObject>();
    private static final Logger log = LoggerFactory.getLogger(Notifier.class);

    private Notifier(ArchetypeService service, boolean syncActive, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.syncActive = syncActive;
        this.transactionManager = transactionManager;
    }

    void notifyRemoved(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        if (this.syncActive) {
            this.removed.add(object);
        } else {
            this.doNotifyRemoved(object, listeners);
        }
    }

    static Notifier getNotifier(ArchetypeService service, PlatformTransactionManager transactionManager) {
        Notifier notifier;
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (!TransactionSynchronizationManager.hasResource((Object)service)) {
                notifier = new Notifier(service, true, transactionManager);
                TransactionSynchronizationManager.bindResource((Object)service, (Object)notifier);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new NotifierSynchronization(notifier));
            } else {
                notifier = (Notifier)TransactionSynchronizationManager.getResource((Object)service);
            }
        } else {
            notifier = new Notifier(service, false, transactionManager);
        }
        return notifier;
    }

    void notifySaving(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        for (IArchetypeServiceListener listener : listeners) {
            if (this.syncActive) {
                this.saved.add(object);
            }
            try {
                listener.save((IMObject)object);
            }
            catch (Exception exception) {
                this.logListenerException(exception);
            }
        }
    }

    void notifyRemoving(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        for (IArchetypeServiceListener listener : listeners) {
            if (this.syncActive) {
                this.removed.add(object);
            }
            try {
                listener.remove((IMObject)object);
            }
            catch (Exception exception) {
                this.logListenerException(exception);
            }
        }
    }

    void notifySaved(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        if (this.syncActive) {
            this.saved.add(object);
        } else {
            this.doNotifySaved(object, listeners);
        }
    }

    private void notifyCommit() {
        this.doInNewTransaction(() -> {
            IArchetypeServiceListener[] listeners;
            for (org.openvpms.component.model.object.IMObject object : this.saved) {
                listeners = this.service.getListeners(object.getArchetype());
                if (listeners == null) continue;
                this.doNotifySaved(object, listeners);
            }
            for (org.openvpms.component.model.object.IMObject object : this.removed) {
                listeners = this.service.getListeners(object.getArchetype());
                if (listeners == null) continue;
                this.doNotifyRemoved(object, listeners);
            }
        });
        this.destroy();
    }

    private void notifyRollback() {
        this.doInNewTransaction(() -> {
            IArchetypeServiceListener[] listeners;
            for (org.openvpms.component.model.object.IMObject object : this.saved) {
                listeners = this.service.getListeners(object.getArchetype());
                if (listeners == null) continue;
                this.doNotifyRollback(object, listeners);
            }
            for (org.openvpms.component.model.object.IMObject object : this.removed) {
                listeners = this.service.getListeners(object.getArchetype());
                if (listeners == null) continue;
                this.doNotifyRollback(object, listeners);
            }
        });
        this.destroy();
    }

    private void doInNewTransaction(final Runnable runnable) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.setPropagationBehavior(3);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                runnable.run();
            }
        });
    }

    private void destroy() {
        this.saved.clear();
        this.removed.clear();
    }

    private void doNotifySaved(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        for (IArchetypeServiceListener listener : listeners) {
            try {
                listener.saved((IMObject)object);
            }
            catch (Exception exception) {
                this.logListenerException(exception);
            }
        }
    }

    private void doNotifyRemoved(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        for (IArchetypeServiceListener listener : listeners) {
            try {
                listener.removed((IMObject)object);
            }
            catch (Exception exception) {
                this.logListenerException(exception);
            }
        }
    }

    private void doNotifyRollback(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        for (IArchetypeServiceListener listener : listeners) {
            try {
                listener.rollback((IMObject)object);
            }
            catch (Exception exception) {
                this.logListenerException(exception);
            }
        }
    }

    private void logListenerException(Exception exception) {
        log.error("Caught unhandled exception from IArchetypeServiceListener", (Throwable)exception);
    }

    private static class NotifierSynchronization
    extends TransactionSynchronizationAdapter {
        private final Notifier notifier;
        private boolean suspended;

        NotifierSynchronization(Notifier notifier) {
            this.notifier = notifier;
        }

        public void suspend() {
            if (TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.notifier.service) != null) {
                this.suspended = true;
            }
        }

        public void resume() {
            if (this.suspended) {
                TransactionSynchronizationManager.bindResource((Object)this.notifier.service, (Object)this.notifier);
                this.suspended = false;
            }
        }

        public void afterCompletion(int status) {
            TransactionSynchronizationManager.unbindResource((Object)this.notifier.service);
            if (status == 0) {
                this.notifier.notifyCommit();
            } else if (status == 1) {
                this.notifier.notifyRollback();
            }
            this.notifier.destroy();
        }
    }
}

