/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Beanable;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.AbstractIMObjectFactory;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IMObjectFactory;
import org.openvpms.component.business.service.archetype.IMObjectValidator;
import org.openvpms.component.business.service.archetype.ListenerRegistrations;
import org.openvpms.component.business.service.archetype.Notifier;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.ruleengine.IRuleEngine;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSet;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.TypedQueryImpl;
import org.openvpms.component.system.common.query.criteria.CriteriaBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ArchetypeService
implements IArchetypeService {
    private final ListenerRegistrations listeners = new ListenerRegistrations();
    private final IMObjectFactory factory;
    private final IMObjectValidator validator;
    private final IArchetypeDescriptorCache dCache;
    private final PlatformTransactionManager transactionManager;
    private final CriteriaBuilderImpl criteriaBuilder;
    private IMObjectDAO dao;
    private IRuleEngine ruleEngine;
    private static final Logger log = LoggerFactory.getLogger(ArchetypeService.class);

    public ArchetypeService(IArchetypeDescriptorCache cache, PlatformTransactionManager transactionManager) {
        this.dCache = cache;
        this.transactionManager = transactionManager;
        this.factory = new ObjectFactory();
        this.validator = new IMObjectValidator(cache);
        this.criteriaBuilder = new CriteriaBuilderImpl(this.dCache);
    }

    public IMObjectDAO getDao() {
        return this.dao;
    }

    public void setDao(IMObjectDAO dao) {
        this.dao = dao;
    }

    public IRuleEngine getRuleEngine() {
        return this.ruleEngine;
    }

    public void setRuleEngine(IRuleEngine ruleEngine) {
        this.ruleEngine = ruleEngine;
    }

    public List<String> getArchetypes(String archetype, boolean primaryOnly) {
        return this.getArchetypeShortNames(archetype, primaryOnly);
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(String shortName) {
        return this.dCache.getArchetypeDescriptor(shortName);
    }

    public org.openvpms.component.model.archetype.AssertionTypeDescriptor getAssertionTypeDescriptor(String name) {
        return this.dCache.getAssertionTypeDescriptor(name);
    }

    public List<org.openvpms.component.model.archetype.AssertionTypeDescriptor> getAssertionTypeDescriptors() {
        return new ArrayList<org.openvpms.component.model.archetype.AssertionTypeDescriptor>(this.dCache.getAssertionTypeDescriptors());
    }

    @Override
    public IMObject create(ArchetypeId id) {
        log.debug("ArchetypeService.create: Creating object of type {}", (Object)id.getShortName());
        return this.factory.create(id);
    }

    @Override
    public IMObject create(String name) {
        log.debug("ArchetypeService.create: Creating object of type {}", (Object)name);
        return this.factory.create(name);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
        IMObject result = this.create(archetype);
        if (result == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NoArchetypeDefinition, archetype);
        }
        return (T)((org.openvpms.component.model.object.IMObject)type.cast(result));
    }

    public List<ValidationError> validate(org.openvpms.component.model.object.IMObject object) {
        return this.validator.validate(object);
    }

    @Override
    public void validateObject(org.openvpms.component.model.object.IMObject object) {
        List<ValidationError> errors = this.validator.validate(object);
        if (!errors.isEmpty()) {
            throw new ValidationException(object.getArchetype(), errors);
        }
    }

    public void deriveValues(org.openvpms.component.model.object.IMObject object) {
        if (object == null) {
            return;
        }
        log.debug("ArchetypeService.deriveValues: Deriving values for type {} with id {} and version {}", new Object[]{object.getArchetype(), object.getId(), object.getVersion()});
        ArchetypeDescriptor descriptor = this.getArchetypeDescriptor(object.getArchetype());
        if (descriptor == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NoArchetypeDefinition, object.getArchetype());
        }
        Map descriptors = descriptor.getNodeDescriptorMap();
        if (!descriptors.isEmpty()) {
            JXPathContext context = JXPathHelper.newContext(object);
            this.deriveValues((IMObject)object, context, descriptors);
        }
    }

    public void deriveValue(org.openvpms.component.model.object.IMObject object, String node) {
        if (object == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NonNullObjectRequired);
        }
        if (StringUtils.isEmpty((CharSequence)node)) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NonNullNodeNameRequired);
        }
        ArchetypeDescriptor adesc = this.getArchetypeDescriptor(object.getArchetype());
        if (adesc == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.InvalidArchetypeDescriptor, object.getArchetype());
        }
        NodeDescriptor ndesc = (NodeDescriptor)adesc.getNodeDescriptor(node);
        if (ndesc == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.InvalidNodeDescriptor, node, object.getArchetype());
        }
        ndesc.deriveValue(object);
    }

    public List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors() {
        return new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>(this.dCache.getArchetypeDescriptors());
    }

    public List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors(String shortName) {
        return new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>(this.dCache.getArchetypeDescriptors(shortName));
    }

    @Override
    public IMObject get(Reference reference) {
        return this.dao.get(reference);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(Reference reference, Class<T> type) {
        return (T)((org.openvpms.component.model.object.IMObject)type.cast(this.get(reference)));
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id) {
        return this.get(new IMObjectReference(archetype, id));
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(String archetype, long id, Class<T> type) {
        return (T)((org.openvpms.component.model.object.IMObject)type.cast(this.get(archetype, id)));
    }

    @Override
    public IMObject get(Reference reference, boolean active) {
        try {
            return this.dao.get(reference, active);
        }
        catch (Exception exception) {
            String message = "select " + reference;
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery, exception, message);
        }
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id, boolean active) {
        return this.get((Reference)new IMObjectReference(archetype, id), active);
    }

    @Override
    public IPage<IMObject> get(IArchetypeQuery query) {
        log.debug("ArchetypeService.get: query {}", (Object)query);
        try {
            return this.dao.get(query);
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery, exception, query.toString());
        }
    }

    @Override
    public IPage<IMObject> get(IArchetypeQuery query, Collection<String> nodes) {
        log.debug("ArchetypeService.get: query={}, nodes={}", (Object)query, nodes);
        try {
            return this.dao.get(query, nodes);
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery, exception, query.toString());
        }
    }

    @Override
    public IPage<ObjectSet> getObjects(IArchetypeQuery query) {
        log.debug("ArchetypeService.getObjects: query={}", (Object)query);
        try {
            return this.dao.getObjects(query);
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery, exception, query.toString());
        }
    }

    @Override
    public IPage<NodeSet> getNodes(IArchetypeQuery query, Collection<String> nodes) {
        log.debug("ArchetypeService.get: query={}, nodes={}", (Object)query, nodes);
        try {
            return this.dao.getNodes(query, nodes);
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery, exception, query.toString());
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> query) {
        return new TypedQueryImpl(this.dao.createQuery(query), query.getResultType(), this.dao);
    }

    @Override
    public void remove(org.openvpms.component.model.object.IMObject object) {
        IArchetypeServiceListener[] matches = this.listeners.get(object.getArchetype());
        this.remove(object, matches);
    }

    @Override
    public void remove(Reference reference) {
        IArchetypeServiceListener[] matches = this.listeners.get(reference.getArchetype());
        if (matches == null) {
            log.debug("ArchetypeService.remove(Reference): Removing object of type {} with id {}", (Object)reference.getArchetype(), (Object)reference.getId());
            try {
                this.dao.delete(reference);
            }
            catch (IMObjectDAOException exception) {
                if (IMObjectDAOException.ErrorCode.CannotDeleteLookupInUse.equals((Object)exception.getErrorCode())) {
                    throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.CannotDeleteLookupInUse, (Throwable)((Object)exception), reference);
                }
                throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeleteObject, (Throwable)((Object)exception), reference);
            }
        } else {
            IMObject object = this.get(reference);
            if (object == null) {
                throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeleteObject, reference);
            }
            this.remove(object, matches);
        }
    }

    @Override
    public void save(org.openvpms.component.model.object.IMObject entity) {
        this.save(entity, true);
    }

    @Override
    public void save(org.openvpms.component.model.object.IMObject object, boolean validate) {
        log.debug("ArchetypeService.save: Saving object of type {} with id {} and version {}", new Object[]{object.getArchetype(), object.getId(), object.getVersion()});
        if (this.dao == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NoDaoConfigured);
        }
        this.notifySave(object, true);
        IMObject unwrapped = this.unwrap(object);
        if (validate) {
            this.validateObject(unwrapped);
        }
        try {
            this.dao.save(unwrapped);
            if (unwrapped instanceof org.openvpms.component.model.archetype.ArchetypeDescriptor || unwrapped instanceof org.openvpms.component.model.archetype.AssertionTypeDescriptor) {
                this.updateCache(object);
            }
            this.notifySave(object, false);
        }
        catch (IMObjectDAOException exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToSaveObject, (Throwable)((Object)exception), object);
        }
    }

    @Override
    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
        this.save(objects, true);
    }

    @Override
    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects, boolean validate) {
        if (this.dao == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.NoDaoConfigured);
        }
        this.notifySave(objects, true);
        List<IMObject> unwrapped = this.unwrap(objects);
        if (validate) {
            for (org.openvpms.component.model.object.IMObject iMObject : unwrapped) {
                this.validateObject(iMObject);
            }
        }
        try {
            this.dao.save(unwrapped);
            for (IMObject iMObject : unwrapped) {
                if (!(iMObject instanceof org.openvpms.component.model.archetype.ArchetypeDescriptor) && !(iMObject instanceof org.openvpms.component.model.archetype.AssertionTypeDescriptor)) continue;
                this.updateCache(iMObject);
            }
            this.notifySave(objects, false);
        }
        catch (IMObjectDAOException exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToSaveCollectionOfObjects, (Throwable)((Object)exception), objects.size());
        }
    }

    @Override
    public List<String> getArchetypeShortNames(String shortName, boolean primaryOnly) {
        return this.dCache.getArchetypeShortNames(shortName, primaryOnly);
    }

    @Override
    public List<String> getArchetypeShortNames() {
        return this.dCache.getArchetypeShortNames();
    }

    @Override
    public List<Object> executeRule(String ruleUri, Map<String, Object> props, List<Object> facts) {
        if (this.ruleEngine == null) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.RuleEngineNotSupported);
        }
        try {
            return this.ruleEngine.executeRules(ruleUri, props, facts);
        }
        catch (Exception exception) {
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteRule, exception, ruleUri);
        }
    }

    @Override
    public void addListener(String shortName, IArchetypeServiceListener listener) {
        List<String> matches = this.getArchetypeShortNames(shortName, false);
        this.listeners.add(shortName, matches, listener);
    }

    @Override
    public void removeListener(String shortName, IArchetypeServiceListener listener) {
        this.listeners.remove(shortName, listener);
    }

    public org.openvpms.component.model.bean.IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return new IMObjectBean(object, this){

            @Override
            public void save() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void save(org.openvpms.component.model.object.IMObject ... objects) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void save(Collection<org.openvpms.component.model.object.IMObject> objects) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected IArchetypeServiceListener[] getListeners(String archetype) {
        return this.listeners.get(archetype);
    }

    private void remove(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners) {
        log.debug("ArchetypeService.remove: Removing object of type {} with id {} and version {}", new Object[]{object.getArchetype(), object.getId(), object.getVersion()});
        this.notifyRemove(object, listeners, true);
        try {
            this.dao.delete((IMObject)object);
            this.notifyRemove(object, listeners, false);
        }
        catch (IMObjectDAOException exception) {
            if (IMObjectDAOException.ErrorCode.CannotDeleteLookupInUse.equals((Object)exception.getErrorCode())) {
                throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.CannotDeleteLookupInUse, (Throwable)((Object)exception), object.getObjectReference());
            }
            throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeleteObject, (Throwable)((Object)exception), object.getObjectReference());
        }
    }

    private IMObject unwrap(org.openvpms.component.model.object.IMObject object) {
        if (object instanceof Beanable) {
            return ((Beanable)object).getObject();
        }
        return (IMObject)object;
    }

    private List<IMObject> unwrap(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        for (org.openvpms.component.model.object.IMObject iMObject : objects) {
            result.add(this.unwrap(iMObject));
        }
        return result;
    }

    private void deriveValues(IMObject object, JXPathContext context, Map<String, NodeDescriptor> nodes) {
        for (NodeDescriptor node : nodes.values()) {
            if (node.isDerived()) {
                try {
                    Object value = context.getValue(node.getDerivedValue());
                    node.setValue(object, context, value);
                }
                catch (Exception exception) {
                    throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeriveValue, exception, node.getName(), node.getPath());
                }
            }
            if (node.getNodeDescriptors().isEmpty()) continue;
            this.deriveValues(object, context, node.getNodeDescriptors());
        }
    }

    private void updateCache(final org.openvpms.component.model.object.IMObject object) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (status == 0) {
                        ArchetypeService.this.addToCache(object);
                    }
                }
            });
        } else {
            this.addToCache(object);
        }
    }

    private void addToCache(org.openvpms.component.model.object.IMObject object) {
        if (object instanceof ArchetypeDescriptor) {
            String archetype = ((org.openvpms.component.model.archetype.ArchetypeDescriptor)object).getArchetypeType();
            boolean exists = this.dCache.getArchetypeDescriptor(archetype) != null;
            ArchetypeDescriptor descriptor = (ArchetypeDescriptor)this.get(object.getObjectReference());
            if (descriptor != null) {
                this.dCache.addArchetypeDescriptor(descriptor);
                if (!exists) {
                    this.listeners.archetypeAdded(archetype);
                }
            }
        } else if (object instanceof AssertionTypeDescriptor) {
            this.dCache.addAssertionTypeDescriptor((AssertionTypeDescriptor)object);
        }
    }

    private void notifySave(org.openvpms.component.model.object.IMObject object, boolean preSave) {
        this.notifySave(object, null, preSave);
    }

    private void notifySave(Collection<? extends org.openvpms.component.model.object.IMObject> objects, boolean preSave) {
        Notifier notifier = null;
        for (org.openvpms.component.model.object.IMObject iMObject : objects) {
            notifier = this.notifySave(iMObject, notifier, preSave);
        }
    }

    private Notifier notifySave(org.openvpms.component.model.object.IMObject object, Notifier notifier, boolean preSave) {
        IArchetypeServiceListener[] matches = this.listeners.get(object.getArchetype());
        if (matches != null) {
            if (notifier == null) {
                notifier = Notifier.getNotifier(this, this.transactionManager);
            }
            if (preSave) {
                notifier.notifySaving(object, matches);
            } else {
                notifier.notifySaved(object, matches);
            }
        }
        return notifier;
    }

    private void notifyRemove(org.openvpms.component.model.object.IMObject object, IArchetypeServiceListener[] listeners, boolean preRemove) {
        if (listeners != null) {
            Notifier notifier = Notifier.getNotifier(this, this.transactionManager);
            if (preRemove) {
                notifier.notifyRemoving(object, listeners);
            } else {
                notifier.notifyRemoved(object, listeners);
            }
        }
    }

    private class ObjectFactory
    extends AbstractIMObjectFactory {
        private ObjectFactory() {
        }

        @Override
        protected ArchetypeDescriptor getArchetypeDescriptor(String shortName) {
            return ArchetypeService.this.dCache.getArchetypeDescriptor(shortName);
        }

        @Override
        protected ArchetypeDescriptor getArchetypeDescriptor(ArchetypeId id) {
            return ArchetypeService.this.dCache.getArchetypeDescriptor(id);
        }
    }
}

