/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.datatypes.property;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.datatypes.property.NamedProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyCollection;

public class PropertyMap
extends NamedProperty
implements PropertyCollection,
org.openvpms.component.model.archetype.PropertyMap {
    private static final long serialVersionUID = 1L;
    private Map<String, org.openvpms.component.model.archetype.NamedProperty> properties = new LinkedHashMap<String, org.openvpms.component.model.archetype.NamedProperty>();

    public PropertyMap() {
        this.setArchetypeId(new ArchetypeId("descriptor.propertyMap.1.0"));
    }

    public PropertyMap(String name) {
        this.setName(name);
    }

    public Map<String, org.openvpms.component.model.archetype.NamedProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, org.openvpms.component.model.archetype.NamedProperty> properties) {
        this.properties = properties;
    }

    public void addProperty(org.openvpms.component.model.archetype.NamedProperty property) {
        this.properties.put(property.getName(), property);
    }

    public void removeProperty(org.openvpms.component.model.archetype.NamedProperty property) {
        this.properties.remove(property.getName());
    }

    public NamedProperty[] getPropertiesAsArray() {
        return this.properties.values().toArray(new NamedProperty[0]);
    }

    public void setPropertiesAsArray(NamedProperty[] properties) {
        this.properties = new LinkedHashMap<String, org.openvpms.component.model.archetype.NamedProperty>();
        for (NamedProperty property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public Collection<org.openvpms.component.model.archetype.NamedProperty> values() {
        return this.properties.values();
    }

    public Object getValue() {
        return this.properties;
    }

    public void setValue(Object value) {
        this.properties = (Map)value;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PropertyMap copy = new PropertyMap();
        copy.setName(this.getName());
        for (org.openvpms.component.model.archetype.NamedProperty property : this.properties.values()) {
            NamedProperty p = (NamedProperty)property;
            copy.addProperty((NamedProperty)p.clone());
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyMap) {
            return Objects.equals(this.getName(), ((PropertyMap)obj).getName()) && this.properties.equals(((PropertyMap)obj).properties);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.properties).toHashCode();
    }
}

