/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.datatypes.basic;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.system.common.xstream.XStreamFactory;

public class TypedValueConverter {
    private static final Map<Class<?>, Pair> convertersByClass;
    private static final Map<String, SingleValueConverter> convertersByName;
    private static final XStream stream;

    private TypedValueConverter() {
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        Pair pair = convertersByClass.get(object.getClass());
        if (pair == null) {
            return stream.toXML(object);
        }
        return pair.converter.toString(object);
    }

    public static Object fromString(String string, String type) {
        if (string == null) {
            return null;
        }
        SingleValueConverter converter = convertersByName.get(type);
        if (converter != null) {
            return converter.fromString(string);
        }
        return stream.fromXML(string);
    }

    public static String getType(Object object) {
        if (object == null) {
            return null;
        }
        Pair pair = convertersByClass.get(object.getClass());
        if (pair == null) {
            return object.getClass().getName();
        }
        return pair.type;
    }

    private static void addConverter(Class<?> type, String name, SingleValueConverter converter) {
        convertersByClass.put(type, new Pair(name, converter));
        convertersByName.put(name, converter);
    }

    static {
        stream = XStreamFactory.create();
        convertersByClass = new HashMap();
        convertersByName = new HashMap<String, SingleValueConverter>();
        TypedValueConverter.addConverter(Integer.class, "int", (SingleValueConverter)new IntConverter());
        TypedValueConverter.addConverter(Float.class, "float", (SingleValueConverter)new FloatConverter());
        TypedValueConverter.addConverter(Double.class, "double", (SingleValueConverter)new DoubleConverter());
        TypedValueConverter.addConverter(Long.class, "long", (SingleValueConverter)new LongConverter());
        TypedValueConverter.addConverter(Short.class, "short", (SingleValueConverter)new ShortConverter());
        TypedValueConverter.addConverter(Character.class, "char", (SingleValueConverter)new CharConverter());
        TypedValueConverter.addConverter(Byte.class, "byte", (SingleValueConverter)new ByteConverter());
        TypedValueConverter.addConverter(Boolean.class, "boolean", (SingleValueConverter)new BooleanConverter());
        TypedValueConverter.addConverter(BigDecimal.class, "big-decimal", (SingleValueConverter)new BigDecimalConverter());
        TypedValueConverter.addConverter(BigInteger.class, "big-int", (SingleValueConverter)new BigIntegerConverter());
        TypedValueConverter.addConverter(String.class, "string", (SingleValueConverter)new StringConverter());
        TypedValueConverter.addConverter(java.util.Date.class, "date", (SingleValueConverter)new DateConverter());
        TypedValueConverter.addConverter(URL.class, "url", (SingleValueConverter)new URLConverter());
        TypedValueConverter.addConverter(Timestamp.class, "sql-timestamp", (SingleValueConverter)new SqlTimestampConverter(TimeZone.getDefault()));
        TypedValueConverter.addConverter(Time.class, "sql-time", (SingleValueConverter)new SqlTimeConverter());
        TypedValueConverter.addConverter(Date.class, "sql-date", (SingleValueConverter)new SqlDateConverter());
        TypedValueConverter.addConverter(Money.class, "money", (SingleValueConverter)new MoneyConverter());
        TypedValueConverter.addConverter(IMObjectReference.class, "object-reference", (SingleValueConverter)new IMObjectReferenceConverter());
    }

    private static class IMObjectReferenceConverter
    extends AbstractSingleValueConverter {
        private IMObjectReferenceConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(IMObjectReference.class);
        }

        public Object fromString(String str) {
            return IMObjectReference.fromString(str);
        }
    }

    private static class MoneyConverter
    extends AbstractSingleValueConverter {
        private MoneyConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(Money.class);
        }

        public Object fromString(String str) {
            return new Money(str);
        }
    }

    private static class CharConverter
    extends AbstractSingleValueConverter {
        private CharConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(Character.TYPE) || type.equals(Character.class);
        }

        public Object fromString(String str) {
            if (str.length() != 1) {
                throw new ConversionException("Cannot convert " + str + " to char");
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    private static class Pair {
        final String type;
        final SingleValueConverter converter;

        public Pair(String type, SingleValueConverter converter) {
            this.type = type;
            this.converter = converter;
        }
    }
}

