/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.Descriptor;

public class PropertyDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private String type = String.class.getName();
    private String value;
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();

    public PropertyDescriptor() {
        this.setArchetypeId(new ArchetypeId("descriptor.property.1.0"));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public void setPropertyDescriptors(Map<String, PropertyDescriptor> properties) {
        this.propertyDescriptors = properties;
    }

    public void addPropertyDescriptor(PropertyDescriptor property) {
        this.propertyDescriptors.put(property.getName(), property);
    }

    public void removePropertyDescriptor(PropertyDescriptor property) {
        this.propertyDescriptors.remove(property.getName());
    }

    public PropertyDescriptor[] getPropertyDescriptorsAsArray() {
        return this.propertyDescriptors.values().toArray(new PropertyDescriptor[0]);
    }

    public void setPropertyDescriptorsAsArray(PropertyDescriptor[] properties) {
        this.propertyDescriptors = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor property : properties) {
            this.propertyDescriptors.put(property.getName(), property);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("type", (Object)this.type).append("value", (Object)this.value).append("properties", this.propertyDescriptors == null ? " NULL" : this.propertyDescriptors).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PropertyDescriptor copy = (PropertyDescriptor)super.clone();
        copy.propertyDescriptors = new HashMap<String, PropertyDescriptor>(this.propertyDescriptors);
        copy.type = this.type;
        copy.value = this.value;
        return copy;
    }
}

