/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ActionContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionException;
import org.openvpms.component.business.domain.im.archetype.descriptor.Descriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.model.archetype.ActionTypeDescriptor;
import org.openvpms.component.system.common.util.ClassHelper;
import org.springframework.beans.factory.BeanFactory;

public class AssertionTypeDescriptor
extends Descriptor
implements org.openvpms.component.model.archetype.AssertionTypeDescriptor {
    private String propertyArchetype;
    private Set<ActionTypeDescriptor> actionTypes = new HashSet<ActionTypeDescriptor>();
    private static final long serialVersionUID = 1L;

    public AssertionTypeDescriptor() {
        this.setArchetypeId(new ArchetypeId("descriptor.assertionType.1.0"));
    }

    public Set<ActionTypeDescriptor> getActionTypes() {
        return this.actionTypes;
    }

    public void setActionTypes(Set<ActionTypeDescriptor> actionTypes) {
        this.actionTypes = actionTypes;
    }

    public ActionTypeDescriptor[] getActionTypesAsArray() {
        return this.actionTypes.toArray(new ActionTypeDescriptor[0]);
    }

    public void setActionTypesAsArray(ActionTypeDescriptor[] actions) {
        for (ActionTypeDescriptor action : actions) {
            this.addActionType(action);
        }
    }

    public void addActionType(ActionTypeDescriptor actionType) {
        this.actionTypes.add(actionType);
    }

    public ActionTypeDescriptor getActionType(String name) {
        if (name != null) {
            for (ActionTypeDescriptor actionType : this.actionTypes) {
                if (!actionType.getName().equals(name)) continue;
                return actionType;
            }
        }
        return null;
    }

    public void removeActionType(ActionTypeDescriptor actionType) {
        this.actionTypes.remove(actionType);
    }

    public String getPropertyArchetype() {
        return this.propertyArchetype;
    }

    public void setPropertyArchetype(String propertyArchetype) {
        this.propertyArchetype = propertyArchetype;
    }

    public Object evaluateAction(String action, Object target, IMObject parent, NodeDescriptor node, AssertionDescriptor assertion, BeanFactory beans) {
        ActionTypeDescriptor descriptor = this.getActionType(action);
        if (descriptor == null) {
            throw new AssertionException(AssertionException.ErrorCode.ActionNotSupportedByAssertion, new Object[]{action, this.getName()});
        }
        try {
            Class<?> clazz = ClassHelper.getClass(descriptor.getClassName());
            return this.evaluate(target, parent, node, assertion, beans, descriptor, clazz);
        }
        catch (Exception exception) {
            throw new AssertionException(AssertionException.ErrorCode.FailedToApplyAssertion, new Object[]{action, this.getName()}, exception);
        }
    }

    public void create(Object target, NodeDescriptor node, AssertionDescriptor assertion, BeanFactory beans) {
        ActionTypeDescriptor actionType = this.getActionType(Actions.create.toString());
        if (actionType != null) {
            this.evaluateAction(Actions.create.toString(), target, null, node, assertion, beans);
        }
    }

    public boolean validate(Object value, IMObject parent, NodeDescriptor node, AssertionDescriptor assertion, BeanFactory beans) {
        boolean result = true;
        ActionTypeDescriptor actionType = this.getActionType(Actions.validate.toString());
        if (actionType != null) {
            result = (Boolean)this.evaluateAction(Actions.validate.toString(), value, parent, node, assertion, beans);
        }
        return result;
    }

    public Object set(Object value, IMObject parent, NodeDescriptor node, AssertionDescriptor assertion, BeanFactory beans) {
        Object result = value;
        ActionTypeDescriptor actionType = this.getActionType(Actions.set.toString());
        if (actionType != null) {
            try {
                result = this.evaluateAction(Actions.set.toString(), value, parent, node, assertion, beans);
            }
            catch (Exception exception) {
                throw new AssertionException(AssertionException.ErrorCode.FailedToApplyAssertion, new Object[]{"assert", this.getName()}, exception);
            }
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AssertionTypeDescriptor copy = (AssertionTypeDescriptor)super.clone();
        copy.actionTypes = new TreeSet<ActionTypeDescriptor>(this.actionTypes);
        copy.propertyArchetype = this.propertyArchetype;
        return copy;
    }

    private Object evaluate(Object target, IMObject parent, NodeDescriptor node, AssertionDescriptor assertion, BeanFactory beans, ActionTypeDescriptor descriptor, Class<?> type) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args;
        Method method;
        try {
            method = type.getMethod(descriptor.getMethodName(), ActionContext.class);
            args = new Object[]{new ActionContext(assertion, parent, node, target, beans)};
        }
        catch (NoSuchMethodException ignore) {
            method = type.getMethod(descriptor.getMethodName(), Object.class, NodeDescriptor.class, AssertionDescriptor.class);
            args = new Object[]{target, node, assertion};
        }
        return method.invoke(null, args);
    }

    static enum Actions {
        create,
        validate,
        set;

    }
}

