/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.pentaho;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.pentaho.LoaderPluginMeta;
import org.openvpms.etl.pentaho.Messages;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="OpenVPMSLoaderPluginDialog", image="todo", pluginType=PluginDialog.PluginType.STEP)
public class LoaderPluginDialog
extends BaseStepDialog
implements StepDialogInterface {
    private final LoaderPluginMeta input;
    private CTabFolder tabFolder;
    private TableView mappingTable;
    private Text idName;
    private Text batchSize;
    private CCombo connection;
    private Button generateLookups;
    private Button skipProcessed;
    private static final String YES = "Y";
    private static final String NO = "N";

    public LoaderPluginDialog(Shell parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, baseStepMeta, transMeta, stepname);
        this.input = (LoaderPluginMeta)baseStepMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener modifyListener = event -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(Messages.get("LoaderPluginDialog.Shell.Label", new Object[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label stepNameLabel = new Label((Composite)this.shell, 131072);
        stepNameLabel.setText(Messages.get("LoaderPluginDialog.Stepname.Label", new Object[0]));
        this.props.setLook((Control)stepNameLabel);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        stepNameLabel.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(modifyListener);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.connection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getMappings().getConnection() == null && this.transMeta.nrDatabases() == 1) {
            this.connection.select(0);
        }
        this.connection.addModifyListener(modifyListener);
        Label idLabel = new Label((Composite)this.shell, 131072);
        idLabel.setText(Messages.get("LoaderPluginDialog.IdField.Label", new Object[0]));
        this.props.setLook((Control)idLabel);
        FormData idLabelFormData = new FormData();
        idLabelFormData.left = new FormAttachment(0, 0);
        idLabelFormData.right = new FormAttachment(middle, -margin);
        idLabelFormData.top = new FormAttachment((Control)this.connection, margin * 2);
        idLabel.setLayoutData((Object)idLabelFormData);
        this.idName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.idName);
        this.idName.addModifyListener(modifyListener);
        FormData idNameFormData = new FormData();
        idNameFormData.left = new FormAttachment(middle, 0);
        idNameFormData.top = new FormAttachment((Control)this.connection, margin * 2);
        idNameFormData.right = new FormAttachment(100, 0);
        this.idName.setLayoutData((Object)idNameFormData);
        Label batchLabel = new Label((Composite)this.shell, 131072);
        batchLabel.setText(Messages.get("LoaderPluginDialog.BatchField.Label", new Object[0]));
        this.props.setLook((Control)batchLabel);
        FormData batchLabelFormData = new FormData();
        batchLabelFormData.left = new FormAttachment(0, 0);
        batchLabelFormData.right = new FormAttachment(middle, -margin);
        batchLabelFormData.top = new FormAttachment((Control)this.idName, margin * 2);
        batchLabel.setLayoutData((Object)batchLabelFormData);
        this.batchSize = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.batchSize);
        this.batchSize.addModifyListener(modifyListener);
        FormData batchSizeFormData = new FormData();
        batchSizeFormData.left = new FormAttachment(middle, 0);
        batchSizeFormData.top = new FormAttachment((Control)this.idName, margin * 2);
        batchSizeFormData.right = new FormAttachment(100, 0);
        this.batchSize.setLayoutData((Object)batchSizeFormData);
        this.tabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.tabFolder, 5);
        CTabItem mapTab = new CTabItem(this.tabFolder, 0);
        mapTab.setText(Messages.get("LoaderPluginDialog.MapTab.TabItem", new Object[0]));
        Composite wSelectComp = new Composite((Composite)this.tabFolder, 0);
        this.props.setLook((Control)wSelectComp);
        FormLayout selectLayout = new FormLayout();
        selectLayout.marginWidth = margin;
        selectLayout.marginHeight = margin;
        wSelectComp.setLayout((Layout)selectLayout);
        Label wlFields = new Label(wSelectComp, 0);
        wlFields.setText(Messages.get("LoaderPluginDialog.Fields.Label", new Object[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int rowCount = this.input.getMappings().getMappingCount();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(Messages.get("LoaderPluginDialog.ColumnInfo.Fieldname", new Object[0]), 1, false), new ColumnInfo(Messages.get("LoaderPluginDialog.ColumnInfo.MapTo", new Object[0]), 1, false), new ColumnInfo(Messages.get("LoaderPluginDialog.ColumnInfo.ExcludeIfNull", new Object[0]), 2, this.getYesNo(), true), new ColumnInfo(Messages.get("LoaderPluginDialog.ColumnInfo.Value", new Object[0]), 1, false), new ColumnInfo(Messages.get("LoaderPluginDialog.ColumnInfo.RemoveDefaultObjects", new Object[0]), 2, this.getYesNo(), true)};
        this.mappingTable = new TableView((VariableSpace)this.transMeta, wSelectComp, 67586, columns, rowCount, modifyListener, this.props);
        Button getButton = new Button(wSelectComp, 8);
        getButton.setText(Messages.get("LoaderPluginDialog.GetMap.Button", new Object[0]));
        getButton.addListener(13, event -> this.get());
        FormData fdGetSelect = new FormData();
        fdGetSelect.right = new FormAttachment(100, 0);
        fdGetSelect.top = new FormAttachment(50, 0);
        getButton.setLayoutData((Object)fdGetSelect);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)getButton, -margin);
        fdFields.bottom = new FormAttachment(100, 0);
        this.mappingTable.setLayoutData((Object)fdFields);
        FormData fdSelectComp = new FormData();
        fdSelectComp.left = new FormAttachment(0, 0);
        fdSelectComp.top = new FormAttachment(0, 0);
        fdSelectComp.right = new FormAttachment(100, 0);
        fdSelectComp.bottom = new FormAttachment(100, 0);
        wSelectComp.setLayoutData((Object)fdSelectComp);
        wSelectComp.layout();
        mapTab.setControl((Control)wSelectComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.batchSize, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        this.tabFolder.setLayoutData((Object)fdTabFolder);
        Button ok = new Button((Composite)this.shell, 8);
        ok.setText(Messages.get("System.Button.OK", new Object[0]));
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(Messages.get("System.Button.Cancel", new Object[0]));
        this.generateLookups = new Button((Composite)this.shell, 32);
        this.generateLookups.setText(Messages.get("LoaderPluginDialog.GenerateLookups", new Object[0]));
        this.skipProcessed = new Button((Composite)this.shell, 32);
        this.skipProcessed.setText(Messages.get("LoaderPluginDialog.SkipProcessed", new Object[0]));
        this.setButtonPositions(new Button[]{ok, cancel, this.generateLookups, this.skipProcessed}, margin, (Control)this.tabFolder);
        ok.addListener(13, event -> this.ok());
        cancel.addListener(13, event -> this.cancel());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                LoaderPluginDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)selectionAdapter);
        this.idName.addSelectionListener((SelectionListener)selectionAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                LoaderPluginDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private String[] getYesNo() {
        return new String[]{YES, NO};
    }

    private void getData() {
        Mappings mappings = this.input.getMappings();
        if (mappings.getConnection() != null) {
            this.connection.setText(this.input.getMappings().getConnection());
        }
        this.tabFolder.setSelection(0);
        if (mappings.getIdColumn() != null) {
            this.idName.setText(mappings.getIdColumn());
        }
        this.batchSize.setText(Long.toString(mappings.getBatchSize()));
        this.generateLookups.setSelection(mappings.getGenerateLookups());
        this.skipProcessed.setSelection(mappings.getSkipProcessed());
        Mapping[] list = mappings.getMapping();
        for (int i = 0; i < list.length; ++i) {
            TableItem item = this.mappingTable.table.getItem(i);
            Mapping mapping = list[i];
            if (mapping.getSource() != null) {
                item.setText(1, mapping.getSource());
            }
            if (mapping.getTarget() != null) {
                item.setText(2, mapping.getTarget());
            }
            if (mapping.getExcludeNull()) {
                item.setText(3, YES);
            } else {
                item.setText(3, NO);
            }
            if (mapping.getValue() != null) {
                item.setText(4, mapping.getValue());
            }
            if (mapping.getRemoveDefaultObjects()) {
                item.setText(5, YES);
                continue;
            }
            item.setText(5, NO);
        }
        this.mappingTable.setRowNums();
        this.mappingTable.optWidth(true);
        this.tabFolder.setSelection(0);
        this.wStepname.setFocus();
        this.wStepname.selectAll();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        Mappings mappings = new Mappings();
        mappings.setConnection(this.connection.getText());
        mappings.setIdColumn(this.idName.getText());
        int value = 1000;
        try {
            value = Integer.parseInt(this.batchSize.getText());
        }
        catch (NumberFormatException ignore) {
            this.batchSize.setText(Integer.toString(value));
        }
        mappings.setBatchSize((long)value);
        mappings.setGenerateLookups(this.generateLookups.getSelection());
        mappings.setSkipProcessed(this.skipProcessed.getSelection());
        int count = this.mappingTable.nrNonEmpty();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.mappingTable.getNonEmpty(i);
            Mapping mapping = new Mapping();
            mapping.setSource(item.getText(1));
            mapping.setTarget(item.getText(2));
            boolean exclude = YES.equals(item.getText(3));
            mapping.setExcludeNull(exclude);
            mapping.setValue(item.getText(4));
            boolean removeDefaultObjects = YES.equals(item.getText(5));
            mapping.setRemoveDefaultObjects(removeDefaultObjects);
            mappings.addMapping(mapping);
        }
        this.input.setMappings(mappings);
        this.dispose();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface row = this.transMeta.getPrevStepFields(this.stepname);
            if (row != null && this.tabFolder.getSelectionIndex() == 0) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)row, (TableView)this.mappingTable, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (KettleException exception) {
            new ErrorDialog(this.shell, Messages.get("LoaderPluginDialog.FailedToGetFields.DialogTitle", new Object[0]), Messages.get("LoaderPluginDialog.FailedToGetFields.DialogMessage", new Object[0]), (Exception)((Object)exception));
        }
    }
}

