/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Descriptor;

public class ClassFile {
    private static final int CLASS_FILE_MAGIC = -889275714;
    public static final short MAJOR_VERSION_JDK_1_1 = 45;
    public static final short MINOR_VERSION_JDK_1_1 = 3;
    public static final short MAJOR_VERSION_JDK_1_2 = 46;
    public static final short MINOR_VERSION_JDK_1_2 = 0;
    public static final short MAJOR_VERSION_JDK_1_3 = 47;
    public static final short MINOR_VERSION_JDK_1_3 = 0;
    public static final short MAJOR_VERSION_JDK_1_4 = 48;
    public static final short MINOR_VERSION_JDK_1_4 = 0;
    private short majorVersion;
    private short minorVersion;
    public List constantPool;
    public short accessFlags;
    public short thisClass;
    public short superclass;
    public short[] interfaces;
    public List fieldInfos;
    public List methodInfos;
    private List attributes;
    private Map constantPoolMap;

    public ClassFile(InputStream inputStream) throws IOException, ClassFormatError {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != -889275714) {
            throw new ClassFormatError("Invalid magic number");
        }
        this.minorVersion = dataInputStream.readShort();
        this.majorVersion = dataInputStream.readShort();
        if (!ClassFile.isRecognizedVersion(this.majorVersion, this.minorVersion)) {
            throw new ClassFormatError("Unrecognized class file format version " + this.majorVersion + "/" + this.minorVersion);
        }
        this.constantPool = new ArrayList();
        this.constantPoolMap = new HashMap();
        this.loadConstantPool(dataInputStream);
        this.accessFlags = dataInputStream.readShort();
        this.thisClass = dataInputStream.readShort();
        this.superclass = dataInputStream.readShort();
        this.interfaces = ClassFile.readShortArray(dataInputStream);
        this.fieldInfos = Collections.unmodifiableList(this.loadFields(dataInputStream));
        this.methodInfos = Collections.unmodifiableList(this.loadMethods(dataInputStream));
        this.attributes = Collections.unmodifiableList(this.loadAttributes(dataInputStream));
    }

    public ClassFile(short s, String string, String string2, String[] stringArray) {
        this.majorVersion = (short)45;
        this.minorVersion = (short)3;
        this.constantPool = new ArrayList();
        this.constantPool.add(null);
        this.constantPoolMap = new HashMap();
        this.accessFlags = s;
        this.thisClass = this.addConstantClassInfo(string);
        this.superclass = this.addConstantClassInfo(string2);
        this.interfaces = new short[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.interfaces[n] = this.addConstantClassInfo(stringArray[n]);
            ++n;
        }
        this.fieldInfos = new ArrayList();
        this.methodInfos = new ArrayList();
        this.attributes = new ArrayList();
    }

    public short addConstantClassInfo(String string) {
        String string2;
        if (Descriptor.isClassOrInterfaceReference(string)) {
            string2 = Descriptor.toInternalForm(string);
        } else if (Descriptor.isArrayReference(string)) {
            string2 = string;
        } else {
            throw new RuntimeException("\"" + Descriptor.toString(string) + "\" is neither a class nor an array");
        }
        return this.addToConstantPool(new ConstantClassInfo(this.addConstantUtf8Info(string2)));
    }

    public short addConstantDoubleInfo(double d) {
        return this.addToConstantPool(new ConstantDoubleInfo(d));
    }

    public short addConstantFieldrefInfo(String string, String string2, String string3) {
        return this.addToConstantPool(new ConstantFieldrefInfo(this.addConstantClassInfo(string), this.addConstantNameAndTypeInfo(string2, string3)));
    }

    public short addConstantFloatInfo(float f) {
        return this.addToConstantPool(new ConstantFloatInfo(f));
    }

    public short addConstantIntegerInfo(int n) {
        return this.addToConstantPool(new ConstantIntegerInfo(n));
    }

    public short addConstantInterfaceMethodrefInfo(String string, String string2, String string3) {
        return this.addToConstantPool(new ConstantInterfaceMethodrefInfo(this.addConstantClassInfo(string), this.addConstantNameAndTypeInfo(string2, string3)));
    }

    public short addConstantLongInfo(long l) {
        return this.addToConstantPool(new ConstantLongInfo(l));
    }

    public short addConstantMethodrefInfo(String string, String string2, String string3) {
        return this.addToConstantPool(new ConstantMethodrefInfo(this.addConstantClassInfo(string), this.addConstantNameAndTypeInfo(string2, string3)));
    }

    private short addConstantNameAndTypeInfo(String string, String string2) {
        return this.addToConstantPool(new ConstantNameAndTypeInfo(this.addConstantUtf8Info(string), this.addConstantUtf8Info(string2)));
    }

    private short addConstantSIFLDInfo(Object object) {
        if (object instanceof String) {
            return this.addConstantStringInfo((String)object);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            return this.addConstantIntegerInfo(((Number)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantIntegerInfo((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Character) {
            return this.addConstantIntegerInfo(((Character)object).charValue());
        }
        if (object instanceof Float) {
            return this.addConstantFloatInfo(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLongInfo((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDoubleInfo((Double)object);
        }
        throw new RuntimeException("Unexpected constant value type \"" + object.getClass().getName() + "\"");
    }

    public short addConstantStringInfo(String string) {
        return this.addToConstantPool(new ConstantStringInfo(this.addConstantUtf8Info(string)));
    }

    public short addConstantUtf8Info(String string) {
        return this.addToConstantPool(new ConstantUtf8Info(string));
    }

    public void addDeprecatedAttribute() {
        this.attributes.add(new DeprecatedAttribute(this.addConstantUtf8Info("Deprecated")));
    }

    public FieldInfo addFieldInfo(short s, String string, String string2, Object object) {
        ArrayList<ConstantValueAttribute> arrayList = new ArrayList<ConstantValueAttribute>();
        if (object != null) {
            arrayList.add(new ConstantValueAttribute(this.addConstantUtf8Info("ConstantValue"), this.addConstantSIFLDInfo(object)));
        }
        FieldInfo fieldInfo = new FieldInfo(s, this.addConstantUtf8Info(string), this.addConstantUtf8Info(string2), arrayList);
        this.fieldInfos.add(fieldInfo);
        return fieldInfo;
    }

    public void addInnerClassesAttributeEntry(InnerClassesAttribute.Entry entry) {
        InnerClassesAttribute innerClassesAttribute = this.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            innerClassesAttribute = new InnerClassesAttribute(this.addConstantUtf8Info("InnerClasses"));
            this.attributes.add(innerClassesAttribute);
        }
        innerClassesAttribute.getEntries().add(entry);
    }

    public MethodInfo addMethodInfo(short s, String string, String string2) {
        MethodInfo methodInfo = new MethodInfo(s, this.addConstantUtf8Info(string), this.addConstantUtf8Info(string2), new ArrayList());
        this.methodInfos.add(methodInfo);
        return methodInfo;
    }

    public void addSourceFileAttribute(String string) {
        this.attributes.add(new SourceFileAttribute(this.addConstantUtf8Info("SourceFile"), this.addConstantUtf8Info(string)));
    }

    private short addToConstantPool(ConstantPoolInfo constantPoolInfo) {
        Short s = (Short)this.constantPoolMap.get(constantPoolInfo);
        if (s != null) {
            return s;
        }
        short s2 = (short)this.constantPool.size();
        this.constantPool.add(constantPoolInfo);
        if (constantPoolInfo.isWide()) {
            this.constantPool.add(null);
        }
        this.constantPoolMap.put(constantPoolInfo, new Short(s2));
        return s2;
    }

    public String getConstantClassName(short s) {
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.getConstantPoolInfo(s);
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.getConstantPoolInfo(constantClassInfo.nameIndex);
        return constantUtf8Info.s;
    }

    public ConstantPoolInfo getConstantPoolInfo(short s) {
        return (ConstantPoolInfo)this.constantPool.get(s);
    }

    public String getConstantUtf8(short s) {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.getConstantPoolInfo(s);
        return constantUtf8Info.s;
    }

    public InnerClassesAttribute getInnerClassesAttribute() {
        Short s = (Short)this.constantPoolMap.get(new ConstantUtf8Info("InnerClasses"));
        if (s == null) {
            return null;
        }
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator.next();
            if (attributeInfo.nameIndex != s || !(attributeInfo instanceof InnerClassesAttribute)) continue;
            return (InnerClassesAttribute)attributeInfo;
        }
        return null;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public static String getSourceResourceName(String string) {
        int n = string.lastIndexOf(46) + 1;
        if ((n = string.indexOf(36, n)) != -1) {
            string = string.substring(0, n);
        }
        return String.valueOf(string.replace('.', '/')) + ".java";
    }

    public String getThisClassName() {
        return this.getConstantClassName(this.thisClass).replace('/', '.');
    }

    public static boolean isRecognizedVersion(short s, short s2) {
        return s == 45 && s2 == 3 || s == 46 && s2 == 0 || s == 47 && s2 == 0 || s == 48 && s2 == 0;
    }

    AttributeInfo loadAttribute(DataInputStream dataInputStream) throws IOException {
        AttributeInfo attributeInfo;
        short s = dataInputStream.readShort();
        int n = dataInputStream.readInt();
        final byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        String string = this.getConstantUtf8(s);
        if ("ConstantValue".equals(string)) {
            attributeInfo = ConstantValueAttribute.loadBody(s, dataInputStream2);
        } else if ("Code".equals(string)) {
            attributeInfo = CodeAttribute.loadBody(s, this, dataInputStream2);
        } else if ("Exceptions".equals(string)) {
            attributeInfo = ExceptionsAttribute.loadBody(s, dataInputStream2);
        } else if ("InnerClasses".equals(string)) {
            attributeInfo = InnerClassesAttribute.loadBody(s, dataInputStream2);
        } else if ("Synthetic".equals(string)) {
            attributeInfo = SyntheticAttribute.loadBody(s, dataInputStream2);
        } else if ("SourceFile".equals(string)) {
            attributeInfo = SourceFileAttribute.loadBody(s, dataInputStream2);
        } else if ("LineNumberTable".equals(string)) {
            attributeInfo = LineNumberTableAttribute.loadBody(s, dataInputStream2);
        } else if ("LocalVariableTable".equals(string)) {
            attributeInfo = LocalVariableTableAttribute.loadBody(s, dataInputStream2);
        } else if ("Deprecated".equals(string)) {
            attributeInfo = DeprecatedAttribute.loadBody(s, dataInputStream2);
        } else {
            return new AttributeInfo(s){

                protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
                    dataOutputStream.write(byArray);
                }
            };
        }
        if (byteArrayInputStream.available() > 0) {
            throw new ClassFormatError(String.valueOf(byArray.length - byteArrayInputStream.available()) + " bytes of trailing garbage in body of attribute \"" + string + "\"");
        }
        return attributeInfo;
    }

    private List loadAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.loadAttribute(dataInputStream));
            ++n2;
        }
        return arrayList;
    }

    private void loadConstantPool(DataInputStream dataInputStream) throws IOException {
        this.constantPool.clear();
        this.constantPoolMap.clear();
        short s = dataInputStream.readShort();
        this.constantPool.add(null);
        short s2 = 1;
        while (s2 < s) {
            ConstantPoolInfo constantPoolInfo = ConstantPoolInfo.loadConstantPoolInfo(dataInputStream);
            this.constantPool.add(constantPoolInfo);
            this.constantPoolMap.put(constantPoolInfo, new Short(s2));
            if (constantPoolInfo instanceof ConstantLongInfo || constantPoolInfo instanceof ConstantDoubleInfo) {
                this.constantPool.add(null);
                s2 = (short)(s2 + 1);
            }
            s2 = (short)(s2 + 1);
        }
    }

    private List loadFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new FieldInfo(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), this.loadAttributes(dataInputStream)));
            ++n2;
        }
        return arrayList;
    }

    private MethodInfo loadMethodInfo(DataInputStream dataInputStream) throws IOException {
        return new MethodInfo(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), this.loadAttributes(dataInputStream));
    }

    private List loadMethods(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.loadMethodInfo(dataInputStream));
            ++n2;
        }
        return arrayList;
    }

    private static byte[] readLengthAndBytes(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    private static short[] readShortArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = dataInputStream.readShort();
            ++n2;
        }
        return sArray;
    }

    public void setVersion(short s, short s2) {
        this.majorVersion = s;
        this.minorVersion = s2;
    }

    public void store(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minorVersion);
        dataOutputStream.writeShort(this.majorVersion);
        ClassFile.storeConstantPool(dataOutputStream, this.constantPool);
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.thisClass);
        dataOutputStream.writeShort(this.superclass);
        ClassFile.storeShortArray(dataOutputStream, this.interfaces);
        ClassFile.storeFields(dataOutputStream, this.fieldInfos);
        ClassFile.storeMethods(dataOutputStream, this.methodInfos);
        ClassFile.storeAttributes(dataOutputStream, this.attributes);
    }

    private static void storeAttributes(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeShort(list.size());
        int n = 0;
        while (n < list.size()) {
            ((AttributeInfo)list.get(n)).store(dataOutputStream);
            ++n;
        }
    }

    private static void storeConstantPool(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeShort(list.size());
        int n = 1;
        while (n < list.size()) {
            ConstantPoolInfo constantPoolInfo = (ConstantPoolInfo)list.get(n);
            if (constantPoolInfo != null) {
                constantPoolInfo.store(dataOutputStream);
            }
            ++n;
        }
    }

    private static void storeFields(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeShort(list.size());
        int n = 0;
        while (n < list.size()) {
            ((FieldInfo)list.get(n)).store(dataOutputStream);
            ++n;
        }
    }

    private static void storeMethods(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeShort(list.size());
        int n = 0;
        while (n < list.size()) {
            ((MethodInfo)list.get(n)).store(dataOutputStream);
            ++n;
        }
    }

    private static void storeShortArray(DataOutputStream dataOutputStream, short[] sArray) throws IOException {
        dataOutputStream.writeShort(sArray.length);
        int n = 0;
        while (n < sArray.length) {
            dataOutputStream.writeShort(sArray[n]);
            ++n;
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.store(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static abstract class ConstantPoolInfo {
        public abstract boolean isWide();

        private static ConstantPoolInfo loadConstantPoolInfo(DataInputStream dataInputStream) throws IOException {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 7: {
                    return new ConstantClassInfo(dataInputStream.readShort());
                }
                case 9: {
                    return new ConstantFieldrefInfo(dataInputStream.readShort(), dataInputStream.readShort());
                }
                case 10: {
                    return new ConstantMethodrefInfo(dataInputStream.readShort(), dataInputStream.readShort());
                }
                case 11: {
                    return new ConstantInterfaceMethodrefInfo(dataInputStream.readShort(), dataInputStream.readShort());
                }
                case 8: {
                    return new ConstantStringInfo(dataInputStream.readShort());
                }
                case 3: {
                    return new ConstantIntegerInfo(dataInputStream.readInt());
                }
                case 4: {
                    return new ConstantFloatInfo(dataInputStream.readFloat());
                }
                case 5: {
                    return new ConstantLongInfo(dataInputStream.readLong());
                }
                case 6: {
                    return new ConstantDoubleInfo(dataInputStream.readDouble());
                }
                case 12: {
                    return new ConstantNameAndTypeInfo(dataInputStream.readShort(), dataInputStream.readShort());
                }
                case 1: {
                    return new ConstantUtf8Info(dataInputStream.readUTF());
                }
            }
            throw new ClassFormatError("Invalid constant pool tag " + by);
        }

        public abstract void store(DataOutputStream var1) throws IOException;
    }

    public static abstract class ConstantValuePoolInfo
    extends ConstantPoolInfo {
        public abstract Object getValue(ClassFile var1);
    }

    public static class ConstantClassInfo
    extends ConstantPoolInfo {
        private final short nameIndex;

        public ConstantClassInfo(short s) {
            this.nameIndex = s;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantClassInfo && ((ConstantClassInfo)object).nameIndex == this.nameIndex;
        }

        public int hashCode() {
            return this.nameIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(this.nameIndex);
        }
    }

    public static class ConstantFieldrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantFieldrefInfo(short s, short s2) {
            this.classIndex = s;
            this.nameAndTypeIndex = s2;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantFieldrefInfo && ((ConstantFieldrefInfo)object).classIndex == this.classIndex && ((ConstantFieldrefInfo)object).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }
    }

    public static class ConstantMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantMethodrefInfo(short s, short s2) {
            this.classIndex = s;
            this.nameAndTypeIndex = s2;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantMethodrefInfo && ((ConstantMethodrefInfo)object).classIndex == this.classIndex && ((ConstantMethodrefInfo)object).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(10);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }
    }

    public static class ConstantInterfaceMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantInterfaceMethodrefInfo(short s, short s2) {
            this.classIndex = s;
            this.nameAndTypeIndex = s2;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantInterfaceMethodrefInfo && ((ConstantInterfaceMethodrefInfo)object).classIndex == this.classIndex && ((ConstantInterfaceMethodrefInfo)object).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public short getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(11);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }
    }

    static class ConstantStringInfo
    extends ConstantValuePoolInfo {
        private final short stringIndex;

        public ConstantStringInfo(short s) {
            this.stringIndex = s;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantStringInfo && ((ConstantStringInfo)object).stringIndex == this.stringIndex;
        }

        public Object getValue(ClassFile classFile) {
            return classFile.getConstantUtf8(this.stringIndex);
        }

        public int hashCode() {
            return this.stringIndex;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(8);
            dataOutputStream.writeShort(this.stringIndex);
        }
    }

    private static class ConstantIntegerInfo
    extends ConstantValuePoolInfo {
        private final int value;

        public ConstantIntegerInfo(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantIntegerInfo && ((ConstantIntegerInfo)object).value == this.value;
        }

        public Object getValue(ClassFile classFile) {
            return new Integer(this.value);
        }

        public int hashCode() {
            return this.value;
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.value);
        }
    }

    private static class ConstantFloatInfo
    extends ConstantValuePoolInfo {
        private final float value;

        public ConstantFloatInfo(float f) {
            this.value = f;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantFloatInfo && ((ConstantFloatInfo)object).value == this.value;
        }

        public Object getValue(ClassFile classFile) {
            return new Float(this.value);
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.value);
        }
    }

    private static class ConstantLongInfo
    extends ConstantValuePoolInfo {
        private final long value;

        public ConstantLongInfo(long l) {
            this.value = l;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantLongInfo && ((ConstantLongInfo)object).value == this.value;
        }

        public Object getValue(ClassFile classFile) {
            return new Long(this.value);
        }

        public int hashCode() {
            return (int)this.value ^ (int)(this.value >> 32);
        }

        public boolean isWide() {
            return true;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.value);
        }
    }

    private static class ConstantDoubleInfo
    extends ConstantValuePoolInfo {
        private final double value;

        public ConstantDoubleInfo(double d) {
            this.value = d;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantDoubleInfo && ((ConstantDoubleInfo)object).value == this.value;
        }

        public Object getValue(ClassFile classFile) {
            return new Double(this.value);
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.value);
            return (int)l ^ (int)(l >> 32);
        }

        public boolean isWide() {
            return true;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.value);
        }
    }

    public static class ConstantNameAndTypeInfo
    extends ConstantPoolInfo {
        private final short nameIndex;
        private final short descriptorIndex;

        public ConstantNameAndTypeInfo(short s, short s2) {
            this.nameIndex = s;
            this.descriptorIndex = s2;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantNameAndTypeInfo && ((ConstantNameAndTypeInfo)object).nameIndex == this.nameIndex && ((ConstantNameAndTypeInfo)object).descriptorIndex == this.descriptorIndex;
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public int hashCode() {
            return this.nameIndex + (this.descriptorIndex << 16);
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeShort(this.descriptorIndex);
        }
    }

    public static class ConstantUtf8Info
    extends ConstantPoolInfo {
        private final String s;

        public ConstantUtf8Info(String string) {
            if (string == null) {
                throw new RuntimeException();
            }
            this.s = string;
        }

        public boolean equals(Object object) {
            return object instanceof ConstantUtf8Info && ((ConstantUtf8Info)object).s.equals(this.s);
        }

        public String getString() {
            return this.s;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean isWide() {
            return false;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(1);
            try {
                dataOutputStream.writeUTF(this.s);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw new ClassFormatError("String constant too long to store in class file");
            }
        }
    }

    public class MethodInfo {
        private final short accessFlags;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List attributes;

        public MethodInfo(short s, short s2, short s3, List list) {
            this.accessFlags = s;
            this.nameIndex = s2;
            this.descriptorIndex = s3;
            this.attributes = list;
        }

        public void addAttribute(AttributeInfo attributeInfo) {
            this.attributes.add(attributeInfo);
        }

        public short getAccessFlags() {
            return this.accessFlags;
        }

        public AttributeInfo[] getAttributes() {
            return this.attributes.toArray(new AttributeInfo[this.attributes.size()]);
        }

        public ClassFile getClassFile() {
            return ClassFile.this;
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public short getNameIndex() {
            return this.nameIndex;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dataOutputStream, this.attributes);
        }
    }

    public static class FieldInfo {
        private final short accessFlags;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List attributes;

        public FieldInfo(short s, short s2, short s3, List list) {
            this.accessFlags = s;
            this.nameIndex = s2;
            this.descriptorIndex = s3;
            this.attributes = list;
        }

        public void addAttribute(AttributeInfo attributeInfo) {
            this.attributes.add(attributeInfo);
        }

        public short getAccessFlags() {
            return this.accessFlags;
        }

        public AttributeInfo[] getAttributes() {
            return this.attributes.toArray(new AttributeInfo[this.attributes.size()]);
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public short getNameIndex() {
            return this.nameIndex;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dataOutputStream, this.attributes);
        }
    }

    public static abstract class AttributeInfo {
        private final short nameIndex;

        public AttributeInfo(short s) {
            this.nameIndex = s;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.storeBody(new DataOutputStream(byteArrayOutputStream));
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(dataOutputStream);
        }

        protected abstract void storeBody(DataOutputStream var1) throws IOException;
    }

    public static class ConstantValueAttribute
    extends AttributeInfo {
        private final short constantValueIndex;

        ConstantValueAttribute(short s, short s2) {
            super(s);
            this.constantValueIndex = s2;
        }

        public short getConstantValueIndex() {
            return this.constantValueIndex;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            return new ConstantValueAttribute(s, dataInputStream.readShort());
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.constantValueIndex);
        }
    }

    public static class ExceptionsAttribute
    extends AttributeInfo {
        private final short[] exceptionIndexes;

        public ExceptionsAttribute(short s, short[] sArray) {
            super(s);
            this.exceptionIndexes = sArray;
        }

        public short[] getExceptionIndexes() {
            short[] sArray = new short[this.exceptionIndexes.length];
            System.arraycopy(this.exceptionIndexes, 0, sArray, 0, sArray.length);
            return sArray;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            return new ExceptionsAttribute(s, ClassFile.readShortArray(dataInputStream));
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            ClassFile.storeShortArray(dataOutputStream, this.exceptionIndexes);
        }
    }

    public static class InnerClassesAttribute
    extends AttributeInfo {
        private final List entries;

        InnerClassesAttribute(short s) {
            super(s);
            this.entries = new ArrayList();
        }

        InnerClassesAttribute(short s, Entry[] entryArray) {
            super(s);
            this.entries = new ArrayList<Entry>(Arrays.asList(entryArray));
        }

        public List getEntries() {
            return this.entries;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            Entry[] entryArray = new Entry[dataInputStream.readShort()];
            int n = 0;
            while (n < entryArray.length) {
                entryArray[n] = new Entry(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort());
                n = (short)(n + 1);
            }
            return new InnerClassesAttribute(s, entryArray);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.entries.size());
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                dataOutputStream.writeShort(entry.innerClassInfoIndex);
                dataOutputStream.writeShort(entry.outerClassInfoIndex);
                dataOutputStream.writeShort(entry.innerNameIndex);
                dataOutputStream.writeShort(entry.innerClassAccessFlags);
            }
        }

        public static class Entry {
            public final short innerClassInfoIndex;
            public final short outerClassInfoIndex;
            public final short innerNameIndex;
            public final short innerClassAccessFlags;

            public Entry(short s, short s2, short s3, short s4) {
                this.innerClassInfoIndex = s;
                this.outerClassInfoIndex = s2;
                this.innerNameIndex = s3;
                this.innerClassAccessFlags = s4;
            }
        }
    }

    public static class SyntheticAttribute
    extends AttributeInfo {
        SyntheticAttribute(short s) {
            super(s);
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) {
            return new SyntheticAttribute(s);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
        }
    }

    public static class SourceFileAttribute
    extends AttributeInfo {
        private final short sourceFileIndex;

        public SourceFileAttribute(short s, short s2) {
            super(s);
            this.sourceFileIndex = s2;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            return new SourceFileAttribute(s, dataInputStream.readShort());
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.sourceFileIndex);
        }
    }

    public static class LineNumberTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        public LineNumberTableAttribute(short s, Entry[] entryArray) {
            super(s);
            this.entries = entryArray;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            Entry[] entryArray = new Entry[dataInputStream.readShort()];
            int n = 0;
            while (n < entryArray.length) {
                entryArray[n] = new Entry(dataInputStream.readShort(), dataInputStream.readShort());
                n = (short)(n + 1);
            }
            return new LineNumberTableAttribute(s, entryArray);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.entries.length);
            int n = 0;
            while (n < this.entries.length) {
                dataOutputStream.writeShort(this.entries[n].startPC);
                dataOutputStream.writeShort(this.entries[n].lineNumber);
                ++n;
            }
        }

        public static class Entry {
            public final short startPC;
            public final short lineNumber;

            public Entry(short s, short s2) {
                this.startPC = s;
                this.lineNumber = s2;
            }
        }
    }

    public static class LocalVariableTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        LocalVariableTableAttribute(short s, Entry[] entryArray) {
            super(s);
            this.entries = entryArray;
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) throws IOException {
            short s2 = dataInputStream.readShort();
            Entry[] entryArray = new Entry[s2];
            short s3 = 0;
            while (s3 < s2) {
                entryArray[s3] = new Entry(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort());
                s3 = (short)(s3 + 1);
            }
            return new LocalVariableTableAttribute(s, entryArray);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.entries.length);
            int n = 0;
            while (n < this.entries.length) {
                Entry entry = this.entries[n];
                dataOutputStream.writeShort(entry.startPC);
                dataOutputStream.writeShort(entry.length);
                dataOutputStream.writeShort(entry.nameIndex);
                dataOutputStream.writeShort(entry.descriptorIndex);
                dataOutputStream.writeShort(entry.index);
                ++n;
            }
        }

        public static class Entry {
            public final short startPC;
            public final short length;
            public final short nameIndex;
            public final short descriptorIndex;
            public final short index;

            public Entry(short s, short s2, short s3, short s4, short s5) {
                this.startPC = s;
                this.length = s2;
                this.nameIndex = s3;
                this.descriptorIndex = s4;
                this.index = s5;
            }
        }
    }

    public static class DeprecatedAttribute
    extends AttributeInfo {
        public DeprecatedAttribute(short s) {
            super(s);
        }

        private static AttributeInfo loadBody(short s, DataInputStream dataInputStream) {
            return new DeprecatedAttribute(s);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
        }
    }

    private static class CodeAttribute
    extends AttributeInfo {
        private final short maxStack;
        private final short maxLocals;
        private final byte[] code;
        private final ExceptionTableEntry[] exceptionTableEntries;
        private final AttributeInfo[] attributes;

        private CodeAttribute(short s, short s2, short s3, byte[] byArray, ExceptionTableEntry[] exceptionTableEntryArray, AttributeInfo[] attributeInfoArray) {
            super(s);
            this.maxStack = s2;
            this.maxLocals = s3;
            this.code = byArray;
            this.exceptionTableEntries = exceptionTableEntryArray;
            this.attributes = attributeInfoArray;
        }

        public static AttributeInfo loadBody(short s, ClassFile classFile, DataInputStream dataInputStream) throws IOException {
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            byte[] byArray = ClassFile.readLengthAndBytes(dataInputStream);
            ExceptionTableEntry[] exceptionTableEntryArray = new ExceptionTableEntry[dataInputStream.readShort()];
            int n = 0;
            while (n < exceptionTableEntryArray.length) {
                exceptionTableEntryArray[n] = new ExceptionTableEntry(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort());
                ++n;
            }
            AttributeInfo[] attributeInfoArray = new AttributeInfo[dataInputStream.readShort()];
            int n2 = 0;
            while (n2 < attributeInfoArray.length) {
                attributeInfoArray[n2] = classFile.loadAttribute(dataInputStream);
                ++n2;
            }
            return new CodeAttribute(s, s2, s3, byArray, exceptionTableEntryArray, attributeInfoArray);
        }

        protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.maxStack);
            dataOutputStream.writeShort(this.maxLocals);
            dataOutputStream.writeInt(this.code.length);
            dataOutputStream.write(this.code);
            dataOutputStream.writeShort(this.exceptionTableEntries.length);
            int n = 0;
            while (n < this.exceptionTableEntries.length) {
                ExceptionTableEntry exceptionTableEntry = this.exceptionTableEntries[n];
                dataOutputStream.writeShort(exceptionTableEntry.startPC);
                dataOutputStream.writeShort(exceptionTableEntry.endPC);
                dataOutputStream.writeShort(exceptionTableEntry.handlerPC);
                dataOutputStream.writeShort(exceptionTableEntry.catchType);
                ++n;
            }
            dataOutputStream.writeShort(this.attributes.length);
            int n2 = 0;
            while (n2 < this.attributes.length) {
                this.attributes[n2].store(dataOutputStream);
                ++n2;
            }
        }

        private static class ExceptionTableEntry {
            private final short startPC;
            private final short endPC;
            private final short handlerPC;
            private final short catchType;

            public ExceptionTableEntry(short s, short s2, short s3, short s4) {
                this.startPC = s;
                this.endPC = s2;
                this.handlerPC = s3;
                this.catchType = s4;
            }
        }
    }
}

