/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.component.math.WeightUnits;

public class Weight
implements Comparable<Weight> {
    public static final Weight ZERO = new Weight(BigDecimal.ZERO, WeightUnits.KILOGRAMS);
    public static final BigDecimal ONE_THOUSAND = BigDecimal.valueOf(1000L);
    public static final BigDecimal ONE_POUND_IN_KILOS = new BigDecimal("0.45359237");
    public static final BigDecimal ONE_KILO_IN_POUNDS = BigDecimal.ONE.divide(ONE_POUND_IN_KILOS, 8, RoundingMode.HALF_UP);
    public static final BigDecimal ONE_POUND_IN_GRAMS = ONE_POUND_IN_KILOS.multiply(ONE_THOUSAND);
    public static final BigDecimal ONE_GRAM_IN_POUNDS = BigDecimal.ONE.divide(ONE_POUND_IN_GRAMS, 8, RoundingMode.HALF_UP);
    private final BigDecimal weight;
    private final WeightUnits units;
    private final Date date;
    private static final MathContext CONTEXT = new MathContext(8, RoundingMode.HALF_UP);

    public Weight(int weight) {
        this(weight, WeightUnits.KILOGRAMS);
    }

    public Weight(BigDecimal weight) {
        this(weight, WeightUnits.KILOGRAMS);
    }

    public Weight(BigDecimal weight, WeightUnits units) {
        this(weight, units, null);
    }

    public Weight(int weight, WeightUnits units) {
        this(BigDecimal.valueOf(weight), units);
    }

    public Weight(BigDecimal weight, WeightUnits units, Date date) {
        this.weight = weight;
        this.units = units;
        this.date = date;
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    public boolean isZero() {
        return Weight.isZero(this.weight);
    }

    public WeightUnits getUnits() {
        return this.units;
    }

    public Date getDate() {
        return this.date;
    }

    public BigDecimal toKilograms() {
        return this.convert(WeightUnits.KILOGRAMS);
    }

    public BigDecimal convert(WeightUnits to) {
        return Weight.convert(this.weight, this.units, to);
    }

    public Weight to(WeightUnits to) {
        return new Weight(this.convert(to), to, this.date);
    }

    public boolean between(BigDecimal lower, BigDecimal upper, WeightUnits units) {
        BigDecimal converted = this.convert(units);
        return lower.compareTo(converted) <= 0 && upper.compareTo(converted) > 0;
    }

    @Override
    public int compareTo(Weight o) {
        BigDecimal converted = o.convert(this.units);
        return this.weight.compareTo(converted);
    }

    public boolean equals(Object obj) {
        return obj instanceof Weight && this.compareTo((Weight)obj) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.weight).append((Object)this.units).hashCode();
    }

    public String toString() {
        return this.weight + " " + (Object)((Object)this.units);
    }

    public static BigDecimal convert(BigDecimal weight, WeightUnits from, WeightUnits to) {
        if (Weight.isZero(weight) || from == to) {
            return weight;
        }
        if (from == WeightUnits.KILOGRAMS) {
            if (to == WeightUnits.GRAMS) {
                return weight.multiply(ONE_THOUSAND);
            }
            if (to == WeightUnits.POUNDS) {
                return weight.divide(ONE_POUND_IN_KILOS, 8, RoundingMode.HALF_UP);
            }
        } else if (from == WeightUnits.GRAMS) {
            if (to == WeightUnits.KILOGRAMS) {
                return weight.divide(ONE_THOUSAND, 2, RoundingMode.HALF_UP);
            }
            if (to == WeightUnits.POUNDS) {
                return weight.divide(ONE_POUND_IN_GRAMS, 8, RoundingMode.HALF_UP);
            }
        } else if (from == WeightUnits.POUNDS) {
            if (to == WeightUnits.KILOGRAMS) {
                return weight.multiply(ONE_POUND_IN_KILOS, CONTEXT);
            }
            if (to == WeightUnits.GRAMS) {
                return weight.multiply(ONE_POUND_IN_GRAMS, CONTEXT);
            }
        } else {
            throw new IllegalArgumentException("Unsupported weight units for argument 'from': " + (Object)((Object)from));
        }
        throw new IllegalArgumentException("Unsupported weight units for argument 'to': " + (Object)((Object)to));
    }

    private static boolean isZero(BigDecimal value) {
        return value.signum() == 0;
    }
}

