/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import java.io.File;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.etl.tools.doc.AbstractLoader;
import org.openvpms.etl.tools.doc.DocumentFactory;
import org.openvpms.etl.tools.doc.DocumentLoaderException;
import org.openvpms.etl.tools.doc.LoadContext;
import org.springframework.transaction.PlatformTransactionManager;

class NameLoader
extends AbstractLoader {
    private final LoadContext context;

    public NameLoader(File dir, String[] shortNames, IArchetypeService service, DocumentFactory factory, PlatformTransactionManager transactionManager, boolean recurse, boolean overwrite, LoadContext context) {
        super(dir, shortNames, service, factory, transactionManager, recurse, overwrite);
        this.context = context;
    }

    @Override
    protected boolean load(File file, boolean overwrite) {
        boolean result = false;
        try {
            DocumentAct act = this.getAct(file, overwrite);
            if (act != null) {
                result = this.load(act, file, overwrite, this.context);
            } else {
                this.context.missingAct(file);
            }
        }
        catch (Exception exception) {
            this.context.error(file, exception);
        }
        return result;
    }

    private DocumentAct getAct(File file, boolean overwrite) {
        IMObjectQueryIterator iterator;
        DocumentAct result = null;
        ArchetypeQuery query = new ArchetypeQuery(this.getShortNames(), true, true);
        query.add((IConstraint)Constraints.eq((String)"fileName", (Object)file.getName()));
        if (!overwrite) {
            query.add((IConstraint)Constraints.isNull((String)"document"));
        }
        if ((iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query)).hasNext()) {
            result = (DocumentAct)iterator.next();
            if (iterator.hasNext()) {
                throw new DocumentLoaderException(DocumentLoaderException.ErrorCode.DuplicateAct, file.getName());
            }
        }
        return result;
    }
}

