/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.tools.doc;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.ExtensionMimeDetector;
import java.io.File;
import java.util.Collection;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.etl.tools.doc.DocumentFactory;

public class DefaultDocumentFactory
implements DocumentFactory {
    private final DocumentHandlers handlers;

    public DefaultDocumentFactory(IArchetypeService service) {
        this.handlers = new DocumentHandlers((ArchetypeService)service);
    }

    @Override
    public Document create(File file) {
        String mimeType = this.getMimeType(file);
        return DocumentHelper.create((File)file, (String)mimeType, (DocumentHandlers)this.handlers);
    }

    protected String getMimeType(File file) {
        try {
            Collection types = MimeUtil.getMimeTypes((File)file);
            MimeType type = MimeUtil.getMostSpecificMimeType((Collection)types);
            return type.toString();
        }
        catch (Exception exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, (Throwable)exception, new Object[]{file.getName()});
        }
    }

    static {
        MimeUtil.registerMimeDetector((String)ExtensionMimeDetector.class.getName());
    }
}

