/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.oscache;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springmodules.cache.provider.AbstractCacheProfileEditor;
import org.springmodules.cache.provider.CacheProfile;
import org.springmodules.cache.provider.oscache.OsCacheProfile;

public final class OsCacheProfileEditor
extends AbstractCacheProfileEditor {
    protected CacheProfile createCacheProfile(Properties properties) {
        OsCacheProfile cacheProfile = null;
        if (properties.isEmpty()) {
            cacheProfile = new OsCacheProfile();
        } else {
            String cronExpression = properties.getProperty("cronExpression");
            String groups = properties.getProperty("groups");
            String refreshPeriodString = properties.getProperty("refreshPeriod");
            Integer refreshPeriod = null;
            if (StringUtils.isNotEmpty((String)refreshPeriodString)) {
                if (refreshPeriodString.equalsIgnoreCase("INDEFINITE_EXPIRY")) {
                    refreshPeriod = new Integer(-1);
                } else {
                    try {
                        refreshPeriod = new Integer(refreshPeriodString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Refresh period should be an integer or the String 'INDEFINITE_EXPIRY'");
                    }
                }
            }
            cacheProfile = new OsCacheProfile();
            cacheProfile.setCronExpression(cronExpression);
            cacheProfile.setGroups(groups);
            cacheProfile.setRefreshPeriod(refreshPeriod);
        }
        return cacheProfile;
    }
}

