/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.EntryRetrievalException;
import org.springmodules.cache.provider.AbstractCacheProfileEditor;
import org.springmodules.cache.provider.CacheProfile;
import org.springmodules.cache.provider.CacheProfileValidator;
import org.springmodules.cache.provider.CacheProviderFacade;

public abstract class AbstractCacheProviderFacadeImpl
implements CacheProviderFacade {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$provider$AbstractCacheProviderFacadeImpl == null ? (class$org$springmodules$cache$provider$AbstractCacheProviderFacadeImpl = AbstractCacheProviderFacadeImpl.class$("org.springmodules.cache.provider.AbstractCacheProviderFacadeImpl")) : class$org$springmodules$cache$provider$AbstractCacheProviderFacadeImpl));
    private boolean cacheProfileMapValidated;
    private Map cacheProfiles;
    private boolean failQuietlyEnabled;
    static /* synthetic */ Class class$org$springmodules$cache$provider$AbstractCacheProviderFacadeImpl;

    public final void afterPropertiesSet() {
        this.validateCacheManager();
        if (this.cacheProfiles == null || this.cacheProfiles.isEmpty()) {
            throw new IllegalStateException("The Map of cache profiles should not be empty");
        }
        if (!this.isCacheProfileMapValidated()) {
            CacheProfileValidator cacheProfileValidator = this.getCacheProfileValidator();
            Set keySet = this.cacheProfiles.keySet();
            Iterator keySetIterator = keySet.iterator();
            while (keySetIterator.hasNext()) {
                String cacheProfileId = (String)keySetIterator.next();
                Object cacheProfile = this.cacheProfiles.get(cacheProfileId);
                try {
                    cacheProfileValidator.validateCacheProfile(cacheProfile);
                }
                catch (Exception exception) {
                    String message = "Exception thrown while validating cache profile '" + cacheProfileId + "': " + exception.getMessage();
                    throw new IllegalStateException(message);
                }
            }
        }
    }

    public final void cancelCacheUpdate(Serializable cacheKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'cancelCacheUpdates(CacheKey)'.  Argument 'cacheKey': " + cacheKey));
        }
        try {
            this.onCancelCacheUpdate(cacheKey);
        }
        catch (RuntimeException exception) {
            this.handleCacheAccessException("Method 'cancelCacheUpdates(CacheKey)'.", exception);
        }
    }

    public final void flushCache(String[] cacheProfileIds) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'flushCache(String[])'. Argument 'cacheProfileIds': " + ArrayUtils.toString((Object)cacheProfileIds)));
        }
        if (cacheProfileIds != null) {
            int cacheProfileIdCount = cacheProfileIds.length;
            try {
                for (int i = 0; i < cacheProfileIdCount; ++i) {
                    String cacheProfileId = cacheProfileIds[i];
                    CacheProfile cacheProfile = this.getCacheProfile(cacheProfileId);
                    if (cacheProfile == null) continue;
                    this.onFlushCache(cacheProfile);
                }
            }
            catch (RuntimeException exception) {
                this.handleCacheAccessException("Method 'flushCache(String[])'.", exception);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Method 'flushCache(String[])'. Cache flushed.");
        }
    }

    protected final CacheProfile getCacheProfile(String cacheProfileId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'getCacheProfile(String)'. Argument 'cacheProfileId': " + cacheProfileId));
        }
        CacheProfile cacheProfile = null;
        if (StringUtils.isNotEmpty((String)cacheProfileId) && this.cacheProfiles != null) {
            cacheProfile = (CacheProfile)this.cacheProfiles.get(cacheProfileId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'getCacheProfile(String)'. Variable 'cacheProfile': " + cacheProfile));
        }
        return cacheProfile;
    }

    protected abstract AbstractCacheProfileEditor getCacheProfileEditor();

    public final Map getCacheProfiles() {
        return Collections.unmodifiableMap(this.cacheProfiles);
    }

    protected abstract CacheProfileValidator getCacheProfileValidator();

    public final Object getFromCache(Serializable cacheKey, String cacheProfileId) throws EntryRetrievalException {
        if (logger.isDebugEnabled()) {
            String message = "Method 'getFromCache(CacheKey, String)'. Argument 'cacheKey': " + cacheKey;
            logger.debug((Object)message);
        }
        Object cachedObject = null;
        try {
            CacheProfile cacheProfile = this.getCacheProfile(cacheProfileId);
            if (cacheProfile != null) {
                cachedObject = this.onGetFromCache(cacheKey, cacheProfile);
            }
            if (logger.isDebugEnabled()) {
                String message = "Method 'getFromCache(CacheKey, String)'. Variable 'cachedObject': " + cachedObject;
                logger.debug((Object)message);
            }
        }
        catch (RuntimeException exception) {
            String message = "Method 'getFromCache(Cachekey, String)'.";
            this.handleCacheAccessException(message, exception);
        }
        return cachedObject;
    }

    protected final void handleCacheAccessException(String loggerMessage, RuntimeException exception) {
        logger.error((Object)loggerMessage, (Throwable)exception);
        if (!this.isFailQuietlyEnabled()) {
            throw exception;
        }
    }

    public final boolean isCacheProfileMapValidated() {
        return this.cacheProfileMapValidated;
    }

    public final boolean isFailQuietlyEnabled() {
        return this.failQuietlyEnabled;
    }

    protected void onCancelCacheUpdate(Serializable cacheKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'onCancelCacheUpdate(CacheKey)'.  Argument 'cacheKey': " + cacheKey));
        }
    }

    protected abstract void onFlushCache(CacheProfile var1);

    protected abstract Object onGetFromCache(Serializable var1, CacheProfile var2) throws EntryRetrievalException;

    protected abstract void onPutInCache(Serializable var1, CacheProfile var2, Object var3);

    public void putInCache(Serializable cacheKey, String cacheProfileId, Object objectToCache) {
        CacheProfile cacheProfile;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method 'putInCache(CacheKey, String)'. Argument 'cacheKey': " + cacheKey));
            logger.debug((Object)("Method 'putInCache(CacheKey, String)'. Argument 'objectToCache': " + objectToCache));
        }
        if ((cacheProfile = this.getCacheProfile(cacheProfileId)) != null) {
            try {
                this.onPutInCache(cacheKey, cacheProfile, objectToCache);
            }
            catch (RuntimeException exception) {
                String message = "Method 'putInCache(CacheKey, String, Object)'.";
                this.handleCacheAccessException(message, exception);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Method 'putInCache(CacheKey, String)'. Object stored in the cache");
        }
    }

    public final void setCacheProfiles(Map cacheProfiles) {
        if (cacheProfiles instanceof Properties) {
            this.setCacheProfiles((Properties)cacheProfiles);
        } else {
            this.cacheProfiles = cacheProfiles;
            this.cacheProfileMapValidated = false;
        }
    }

    public final void setCacheProfiles(Properties cacheProfiles) {
        if (cacheProfiles == null || cacheProfiles.isEmpty()) {
            throw new IllegalArgumentException("The properties of the cache profiles should not be empty");
        }
        LinkedHashMap<String, CacheProfile> newCacheProfiles = null;
        Iterator<Object> keySetIterator = cacheProfiles.keySet().iterator();
        AbstractCacheProfileEditor cacheProfileEditor = this.getCacheProfileEditor();
        newCacheProfiles = new LinkedHashMap<String, CacheProfile>();
        while (keySetIterator.hasNext()) {
            String cacheProfileId = (String)keySetIterator.next();
            String cacheProfileProperties = cacheProfiles.getProperty(cacheProfileId);
            CacheProfile cacheProfile = null;
            try {
                cacheProfileEditor.setAsText(cacheProfileProperties);
                cacheProfile = (CacheProfile)cacheProfileEditor.getValue();
            }
            catch (Exception exception) {
                String message = "Exception thrown while creating the cache profile with id '" + cacheProfileId + "': " + exception.getMessage();
                throw new IllegalArgumentException(message);
            }
            newCacheProfiles.put(cacheProfileId, cacheProfile);
        }
        this.cacheProfiles = newCacheProfiles;
        this.cacheProfileMapValidated = true;
    }

    public final void setFailQuietlyEnabled(boolean failQuietlyEnabled) {
        this.failQuietlyEnabled = failQuietlyEnabled;
    }

    protected abstract void validateCacheManager();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

