/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.pojorule;

import java.util.ArrayList;
import org.drools.rule.Declaration;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Tuple;
import org.drools.spring.pojorule.Argument;
import org.drools.spring.pojorule.FactArgument;
import org.drools.spring.pojorule.RuleReflectMethod;

public class PojoCondition
implements Condition {
    private final RuleReflectMethod ruleMethod;
    private final Declaration[] requiredDeclarations;

    public PojoCondition(RuleReflectMethod ruleMethod) {
        this.ruleMethod = ruleMethod;
        this.requiredDeclarations = PojoCondition.extractDeclarations(ruleMethod.getArguments());
    }

    public String getMethodName() {
        return this.ruleMethod.getMethodName();
    }

    private static Declaration[] extractDeclarations(Argument[] arguments) {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            if (!(argument instanceof FactArgument)) continue;
            declarations.add(((FactArgument)argument).getDeclaration());
        }
        return declarations.toArray(new Declaration[declarations.size()]);
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDeclarations;
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            return (Boolean)this.ruleMethod.invokeMethod(tuple);
        }
        catch (Exception e) {
            throw new ConditionException(e);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PojoCondition)) {
            return false;
        }
        PojoCondition pojoCondition = (PojoCondition)other;
        return this.ruleMethod.equals(pojoCondition.ruleMethod);
    }

    public int hashCode() {
        return this.ruleMethod.hashCode();
    }

    public String toString() {
        return this.ruleMethod.toString();
    }
}

