/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.drools.spring.metadata.MethodMetadata;
import org.drools.spring.metadata.MethodMetadataSource;
import org.drools.spring.metadata.StoppingClassCapable;

public class AccessAndReturnTypeMethodMetadataSource
implements MethodMetadataSource,
StoppingClassCapable {
    private static final MethodMetadata METHOD_CONDITION_METADATA = new MethodMetadata(0);
    private static final MethodMetadata METHOD_CONSEQUENCE_METADATA = new MethodMetadata(1);
    private static final MethodMetadata OBJECT_CONDITION_METADATA = new MethodMetadata(3);
    private Class stoppingClass = Object.class;

    public void setStoppingClass(Class stoppingClass) {
        this.stoppingClass = stoppingClass;
    }

    public MethodMetadata getMethodMetadata(Method method) {
        if (method.getDeclaringClass().isAssignableFrom(this.stoppingClass)) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (this.isReturnTypeBoolean(method) && this.hasParameters(method)) {
            return METHOD_CONDITION_METADATA;
        }
        if (!this.isReturnTypePrimitive(method) && !this.hasParameters(method)) {
            return OBJECT_CONDITION_METADATA;
        }
        if (this.isReturnTypeVoid(method)) {
            return METHOD_CONSEQUENCE_METADATA;
        }
        return null;
    }

    private boolean isReturnTypePrimitive(Method method) {
        return method.getReturnType().isPrimitive();
    }

    private boolean isReturnTypeBoolean(Method method) {
        return Boolean.TYPE.isAssignableFrom(method.getReturnType());
    }

    private boolean isReturnTypeVoid(Method method) {
        return Void.TYPE.isAssignableFrom(method.getReturnType());
    }

    private boolean hasParameters(Method method) {
        return method.getParameterTypes().length > 0;
    }
}

