/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.DroolsException;
import org.drools.rule.Rule;
import org.drools.spring.metadata.ArgumentMetadata;
import org.drools.spring.metadata.ArgumentMetadataSource;
import org.drools.spring.metadata.MethodMetadata;
import org.drools.spring.metadata.MethodMetadataSource;
import org.drools.spring.pojorule.Argument;
import org.drools.spring.pojorule.PojoCondition;
import org.drools.spring.pojorule.PojoConsequence;
import org.drools.spring.pojorule.RuleReflectMethod;

public class RuleBuilder {
    private MethodMetadataSource methodMetadataSource;
    private ArgumentMetadataSource argumentMetadataSource;
    private static Log log = LogFactory.getLog((Class)RuleBuilder.class);

    public void setMethodMetadataSource(MethodMetadataSource methodMetadataSource) {
        this.methodMetadataSource = methodMetadataSource;
    }

    public void setArgumentMetadataSource(ArgumentMetadataSource argumentMetadataSource) {
        this.argumentMetadataSource = argumentMetadataSource;
    }

    public Rule buildRule(Rule rule, Object pojo) throws DroolsException {
        ArrayList<RuleReflectMethod> conditionRuleReflectMethods = new ArrayList<RuleReflectMethod>();
        Method[] pojoMethods = pojo.getClass().getMethods();
        for (int i = 0; i < pojoMethods.length; ++i) {
            Method pojoMethod = pojoMethods[i];
            MethodMetadata methodMetadata = this.methodMetadataSource.getMethodMetadata(pojoMethod);
            if (methodMetadata == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No metadata for method " + pojoMethod.toString()));
                continue;
            }
            ArgumentMetadata[] argumentsMetadata = this.getArgumentMetadata(pojoMethod);
            Argument[] arguments = this.getArguments(rule, argumentsMetadata);
            if (methodMetadata.getMethodType() == 0) {
                RuleBuilder.assertReturnType(pojoMethod, Boolean.TYPE);
                rule.addCondition(new PojoCondition(new RuleReflectMethod(rule, pojo, pojoMethod, arguments)));
                log.info((Object)("Condition method added to rule: " + pojoMethod.toString()));
                continue;
            }
            if (methodMetadata.getMethodType() == 1) {
                conditionRuleReflectMethods.add(new RuleReflectMethod(rule, pojo, pojoMethod, arguments));
                log.info((Object)("Consequence method added to rule: " + pojoMethod.toString()));
                continue;
            }
            if (methodMetadata.getMethodType() != 3) continue;
            if (arguments.length != 0) {
                throw new InvalidPojoConditionException("Rule pojo condition must not have arguments: method = " + pojoMethod + ", arguments = " + arguments);
            }
            try {
                this.buildObjectConditions(rule, pojoMethod.invoke(pojo, new Object[0]));
                continue;
            }
            catch (Exception e) {
                throw new InvalidPojoConditionException("Unable to execute pojo condition: method = " + pojoMethod, e);
            }
        }
        if (!conditionRuleReflectMethods.isEmpty()) {
            this.addConsequence(rule, conditionRuleReflectMethods);
        }
        rule.checkValidity();
        return rule;
    }

    private void buildObjectConditions(Rule rule, Object pojo) throws DroolsException {
        Method[] pojoMethods = pojo.getClass().getMethods();
        for (int i = 0; i < pojoMethods.length; ++i) {
            Method pojoMethod = pojoMethods[i];
            MethodMetadata methodMetadata = this.methodMetadataSource.getMethodMetadata(pojoMethod);
            if (methodMetadata == null) continue;
            ArgumentMetadata[] argumentsMetadata = this.getArgumentMetadata(pojoMethod);
            Argument[] arguments = this.getArguments(rule, argumentsMetadata);
            if (methodMetadata.getMethodType() != 0) continue;
            RuleBuilder.assertReturnType(pojoMethod, Boolean.TYPE);
            rule.addCondition(new PojoCondition(new RuleReflectMethod(rule, pojo, pojoMethod, arguments)));
        }
    }

    private ArgumentMetadata[] getArgumentMetadata(Method pojoMethod) throws InvalidParameterException {
        Class<?>[] parameterTypes = pojoMethod.getParameterTypes();
        ArgumentMetadata[] metadata = new ArgumentMetadata[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            metadata[i] = this.argumentMetadataSource.getArgumentMetadata(pojoMethod, parameterTypes[i], i);
            if (metadata[i] != null) continue;
            throw new InvalidParameterException("Cannot determine parameter metdata: method=" + pojoMethod.getName() + ", parameterType[" + i + "]=" + parameterTypes[i]);
        }
        return metadata;
    }

    private Argument[] getArguments(Rule rule, ArgumentMetadata[] argumentsMetadata) throws DroolsException {
        Argument[] arguments = new Argument[argumentsMetadata.length];
        for (int i = 0; i < argumentsMetadata.length; ++i) {
            arguments[i] = argumentsMetadata[i].createArgument(rule);
        }
        return arguments;
    }

    private static void assertReturnType(Method method, Class returnClass) throws InvalidReturnTypeException {
        if (method.getReturnType() != returnClass) {
            throw new InvalidReturnTypeException("Rule method returns the wrong class: method = " + method + ", expected return class = " + returnClass + ", actual return class = " + method.getReturnType());
        }
    }

    private void addConsequence(Rule rule, List conditionRuleReflectMethodsCollector) {
        RuleReflectMethod[] conditionRuleReflectMethodArray = conditionRuleReflectMethodsCollector.toArray(new RuleReflectMethod[conditionRuleReflectMethodsCollector.size()]);
        PojoConsequence consequence = new PojoConsequence(conditionRuleReflectMethodArray);
        rule.setConsequence(consequence);
    }

    public static final class InvalidPojoConditionException
    extends DroolsException {
        InvalidPojoConditionException(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }

        InvalidPojoConditionException(String message) {
            super(message);
        }
    }

    public static final class InvalidParameterException
    extends DroolsException {
        InvalidParameterException(String message) {
            super(message);
        }
    }

    public static final class InvalidReturnTypeException
    extends DroolsException {
        InvalidReturnTypeException(String message) {
            super(message);
        }
    }
}

