/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.smf.ApplicationDataFactory;
import org.drools.smf.ConditionFactory;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DurationFactory;
import org.drools.smf.FunctionsFactory;
import org.drools.smf.ImportEntryFactory;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;

public class SimpleSemanticModule
implements SemanticModule {
    private String uri;
    private Map ruleFactories;
    private Map objectTypeFactories;
    private Map conditionFactories;
    private Map consequenceFactories;
    private Map durationFactories;
    private Map importEntryFactories;
    private Map applicationDataFactories;
    private Map functionFactories;
    private Map types;

    public SimpleSemanticModule(String uri) {
        this.uri = uri;
        this.ruleFactories = new HashMap();
        this.objectTypeFactories = new HashMap();
        this.conditionFactories = new HashMap();
        this.consequenceFactories = new HashMap();
        this.durationFactories = new HashMap();
        this.importEntryFactories = new HashMap();
        this.applicationDataFactories = new HashMap();
        this.functionFactories = new HashMap();
        this.types = new HashMap();
    }

    public String getUri() {
        return this.uri;
    }

    public String getType(String name) {
        return (String)this.types.get(name);
    }

    public void addRuleFactory(String name, RuleFactory factory) {
        this.ruleFactories.put(name, factory);
        this.types.put(name, "Rule");
    }

    public RuleFactory getRuleFactory(String name) {
        return (RuleFactory)this.ruleFactories.get(name);
    }

    public Set getRuleFactoryNames() {
        return this.ruleFactories.keySet();
    }

    public void addObjectTypeFactory(String name, ObjectTypeFactory factory) {
        this.objectTypeFactories.put(name, factory);
        this.types.put(name, "ObjectType");
    }

    public ObjectTypeFactory getObjectTypeFactory(String name) {
        return (ObjectTypeFactory)this.objectTypeFactories.get(name);
    }

    public Set getObjectTypeFactoryNames() {
        return this.objectTypeFactories.keySet();
    }

    public void addConditionFactory(String name, ConditionFactory factory) {
        this.conditionFactories.put(name, factory);
        this.types.put(name, "Condition");
    }

    public ConditionFactory getConditionFactory(String name) {
        return (ConditionFactory)this.conditionFactories.get(name);
    }

    public Set getConditionFactoryNames() {
        return this.conditionFactories.keySet();
    }

    public void addConsequenceFactory(String name, ConsequenceFactory factory) {
        this.consequenceFactories.put(name, factory);
        this.types.put(name, "Consequence");
    }

    public ConsequenceFactory getConsequenceFactory(String name) {
        return (ConsequenceFactory)this.consequenceFactories.get(name);
    }

    public Set getConsequenceFactoryNames() {
        return this.consequenceFactories.keySet();
    }

    public void addDurationFactory(String name, DurationFactory factory) {
        this.durationFactories.put(name, factory);
        this.types.put(name, "Duration");
    }

    public DurationFactory getDurationFactory(String name) {
        return (DurationFactory)this.durationFactories.get(name);
    }

    public Set getDurationFactoryNames() {
        return this.durationFactories.keySet();
    }

    public void addImportEntryFactory(String name, ImportEntryFactory factory) {
        this.importEntryFactories.put(name, factory);
        this.types.put(name, "ImportEntry");
    }

    public ImportEntryFactory getImportEntryFactory(String name) {
        return (ImportEntryFactory)this.importEntryFactories.get(name);
    }

    public Set getImportEntryFactoryNames() {
        return this.importEntryFactories.keySet();
    }

    public void addApplicationDataFactory(String name, ApplicationDataFactory factory) {
        this.applicationDataFactories.put(name, factory);
        this.types.put(name, "ApplicationData");
    }

    public ApplicationDataFactory getApplicationDataFactory(String name) {
        return (ApplicationDataFactory)this.applicationDataFactories.get(name);
    }

    public Set getApplicationDataFactoryNames() {
        return this.applicationDataFactories.keySet();
    }

    public void addFunctionsFactory(String name, FunctionsFactory factory) {
        this.functionFactories.put(name, factory);
        this.types.put(name, "Functions");
    }

    public FunctionsFactory getFunctionsFactory(String name) {
        return (FunctionsFactory)this.functionFactories.get(name);
    }

    public Set getFunctionsFactoryNames() {
        return this.functionFactories.keySet();
    }
}

