/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.IOException;
import java.util.HashMap;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.Scanner;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.java.CompilationException;
import org.drools.semantics.java.JavaFunctions;
import org.drools.semantics.java.JavaScriptEvaluator;
import org.drools.spi.RuleBaseContext;

class JavaCompiler {
    private static final String[] PARAM_NAMES = new String[]{"tuple", "decls", "drools", "applicationData"};

    JavaCompiler() {
    }

    public static Object compile(Rule rule, String className, Class clazz, String expression, String originalExpression, Declaration[] params) throws IOException, CompilationException, ClassNotFoundException {
        try {
            RuleBaseContext ruleBaseContext;
            ClassLoader classLoader;
            JavaFunctions functions = (JavaFunctions)rule.getRuleSet().getFunctions("java");
            Class functionsClass = null;
            if (functions != null) {
                functionsClass = functions.getFunctionsClass();
            }
            if ((classLoader = (ClassLoader)(ruleBaseContext = rule.getRuleSet().getRuleBaseContext()).get("java-classLoader")) == null) {
                ClassLoader cl = (ClassLoader)ruleBaseContext.get("smf-classLoader");
                if (cl == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                    ruleBaseContext.put("smf-classLoader", cl);
                }
                if (cl == null) {
                    cl = JavaCompiler.class.getClassLoader();
                    ruleBaseContext.put("smf-classLoader", cl);
                }
                classLoader = new ByteArrayClassLoader(new HashMap(), cl);
                ruleBaseContext.put("java-classLoader", classLoader);
            }
            return JavaScriptEvaluator.compile(expression, className, clazz, PARAM_NAMES, params, rule.getImporter(), rule.getApplicationData(), functionsClass, classLoader);
        }
        catch (Scanner.LocatedException e) {
            throw new CompilationException(rule.getRuleSet(), rule, originalExpression, e.getLocation() != null ? (int)e.getLocation().getLineNumber() : -1, e.getLocation() != null ? (int)e.getLocation().getColumnNumber() : -1, e.getMessage());
        }
    }
}

