/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import org.drools.rule.Rule;
import org.drools.semantics.base.ClassObjectType;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.ObjectTypeFactory;
import org.drools.spi.Importer;
import org.drools.spi.ObjectType;
import org.drools.spi.RuleBaseContext;

public class ClassObjectTypeFactory
implements ObjectTypeFactory {
    private static final ClassObjectTypeFactory INSTANCE = new ClassObjectTypeFactory();

    public static ClassObjectTypeFactory getInstance() {
        return INSTANCE;
    }

    public ObjectType newObjectType(Rule rule, RuleBaseContext context, Configuration config) throws FactoryException {
        String className = config.getText().trim();
        if (className == null || className.trim().equals("")) {
            throw new FactoryException("no class name specified");
        }
        Class clazz = null;
        try {
            ClassLoader cl = (ClassLoader)context.get("smf-classLoader");
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
                context.put("smf-classLoader", cl);
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
                context.put("smf-classLoader", cl);
            }
            Importer importer = rule.getImporter();
            clazz = importer.importClass(cl, className);
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (Error e) {
            throw new FactoryException(e.getMessage());
        }
        return new ClassObjectType(clazz);
    }
}

