/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;

class TupleSet
implements Serializable {
    private Map tuples;

    TupleSet() {
        this.tuples = new HashMap();
    }

    TupleSet(int initialCapacity, float loadFactor) {
        this.tuples = new HashMap(initialCapacity, loadFactor);
    }

    TupleSet(ReteTuple tuple) {
        this.tuples = Collections.singletonMap(tuple.getKey(), tuple);
    }

    public int size() {
        return this.tuples.size();
    }

    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public void addTuple(ReteTuple tuple) {
        this.tuples.put(tuple.getKey(), tuple);
    }

    public boolean removeAllTuples(TupleKey key) {
        boolean removed = false;
        Iterator tupleIter = this.tuples.values().iterator();
        while (tupleIter.hasNext()) {
            if (!((ReteTuple)tupleIter.next()).getKey().containsAll(key)) continue;
            tupleIter.remove();
            removed = true;
        }
        return removed;
    }

    public ReteTuple getTuple(TupleKey key) {
        return (ReteTuple)this.tuples.get(key);
    }

    public void removeTuple(TupleKey key) {
        if (1 == this.tuples.size()) {
            this.tuples = new HashMap();
        } else {
            this.tuples.remove(key);
        }
    }

    public Iterator iterator() {
        return this.tuples.values().iterator();
    }

    public String toString() {
        return this.tuples.values().toString();
    }
}

