/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.examples.conway.Cell;
import org.drools.examples.conway.CellState;
import org.drools.examples.conway.patterns.ConwayPattern;
import org.drools.examples.conway.rules.RuleBaseFactory;

public class CellGrid {
    private final Cell[][] cells;

    public CellGrid(int rows, int columns) {
        this.cells = new Cell[rows][columns];
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Cell newCell;
                this.cells[row][column] = newCell = new Cell();
                if (row > 0) {
                    newCell.addNeighbor(this.cells[row - 1][column]);
                    if (column <= columns - 2) {
                        newCell.addNeighbor(this.cells[row - 1][column + 1]);
                    }
                }
                if (column <= 0) continue;
                newCell.addNeighbor(this.cells[row][column - 1]);
                if (row <= 0) continue;
                newCell.addNeighbor(this.cells[row - 1][column - 1]);
            }
        }
    }

    public Cell getCellAt(int row, int column) {
        return this.cells[row][column];
    }

    public int getNumberOfRows() {
        return this.cells.length;
    }

    public int getNumberOfColumns() {
        return this.cells[0].length;
    }

    public boolean nextGeneration() {
        boolean didStateChange = false;
        try {
            RuleBase ruleBase = RuleBaseFactory.getRuleBase();
            WorkingMemory workingMemory = ruleBase.newWorkingMemory();
            Cell[] rowOfCells = null;
            Cell cell = null;
            for (int i = 0; i < this.cells.length; ++i) {
                rowOfCells = this.cells[i];
                for (int j = 0; j < rowOfCells.length; ++j) {
                    cell = rowOfCells[j];
                    workingMemory.assertObject(cell);
                }
            }
            workingMemory.fireAllRules();
            didStateChange = this.transitionState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return didStateChange;
    }

    public int getNumberOfLiveCells() {
        int number = 0;
        Cell[] rowOfCells = null;
        Cell cell = null;
        for (int i = 0; i < this.cells.length; ++i) {
            rowOfCells = this.cells[i];
            for (int j = 0; j < rowOfCells.length; ++j) {
                cell = rowOfCells[j];
                if (cell.getCellState() != CellState.LIVE) continue;
                ++number;
            }
        }
        return number;
    }

    public void killAll() {
        Cell[] rowOfCells = null;
        Cell cell = null;
        for (int i = 0; i < this.cells.length; ++i) {
            rowOfCells = this.cells[i];
            for (int j = 0; j < rowOfCells.length; ++j) {
                cell = rowOfCells[j];
                cell.setCellState(CellState.DEAD);
            }
        }
    }

    public boolean transitionState() {
        boolean stateChanged = false;
        Cell[] rowOfCells = null;
        Cell cell = null;
        for (int i = 0; i < this.cells.length; ++i) {
            rowOfCells = this.cells[i];
            for (int j = 0; j < rowOfCells.length; ++j) {
                cell = rowOfCells[j];
                stateChanged |= cell.transitionState();
            }
        }
        return stateChanged;
    }

    public void setPattern(ConwayPattern pattern) {
        boolean[][] gridData = pattern.getPattern();
        int gridWidth = gridData[0].length;
        int gridHeight = gridData.length;
        int columnOffset = 0;
        int rowOffset = 0;
        if (gridWidth > this.getNumberOfColumns()) {
            gridWidth = this.getNumberOfColumns();
        } else {
            columnOffset = (this.getNumberOfColumns() - gridWidth) / 2;
        }
        if (gridHeight > this.getNumberOfRows()) {
            gridHeight = this.getNumberOfRows();
        } else {
            rowOffset = (this.getNumberOfRows() - gridHeight) / 2;
        }
        this.killAll();
        for (int column = 0; column < gridWidth; ++column) {
            for (int row = 0; row < gridHeight; ++row) {
                if (!gridData[row][column]) continue;
                Cell cell = this.getCellAt(row + rowOffset, column + columnOffset);
                cell.setCellState(CellState.LIVE);
            }
        }
    }
}

