/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.DRLElement;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.Duration;
import org.drools.decisiontable.model.Parameter;

public class Rule
extends DRLElement
implements DRLJavaEmitter {
    private static final int MAX_ROWS = 65535;
    private Integer _salience;
    private String _name;
    private Duration _duration;
    private List _parameters;
    private List _conditions;
    private List _consequences;

    public Rule(String name, Integer salience) {
        this._name = name;
        this._salience = salience;
        this._parameters = new LinkedList();
        this._conditions = new LinkedList();
        this._consequences = new LinkedList();
    }

    public void addParameter(Parameter param) {
        this._parameters.add(param);
    }

    public void setParameters(List parameterList) {
        this._parameters = parameterList;
    }

    public void addCondition(Condition con) {
        this._conditions.add(con);
    }

    public void addConsequence(Consequence con) {
        this._consequences.add(con);
    }

    public String toXML() {
        String xml = "<!--" + this.getComment() + "-->\n";
        xml = xml + "<rule name=\"" + this._name + "\"";
        if (this._salience != null) {
            xml = xml + " salience=\"" + this._salience.toString() + "\"";
        }
        xml = xml + ">\n";
        xml = xml + this.generateXml(this._parameters);
        xml = xml + this.generateXml(this._conditions);
        if (this._duration != null) {
            xml = xml + this._duration.toXML();
        }
        xml = xml + "\t<java:consequence><![CDATA[ \n";
        xml = xml + this.generateXml(this._consequences);
        xml = xml + "\t ]]></java:consequence>";
        xml = xml + "\n" + "</rule>\n\n";
        return xml;
    }

    private String generateXml(List list) {
        StringBuffer buf = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DRLJavaEmitter emitter = (DRLJavaEmitter)it.next();
            buf.append(emitter.toXML());
        }
        return buf.toString();
    }

    public static int calcSalience(int rowNumber) {
        if (rowNumber > 65535) {
            throw new IllegalArgumentException("That row number is above the max: 65535");
        }
        return 65535 - rowNumber;
    }

    public static String convertColNumToColName(int i) {
        String result;
        int div = i / 26;
        int mod = i % 26;
        if (div == 0) {
            byte[] c = new byte[]{(byte)(mod + 65)};
            result = Rule.byteToString(c);
        } else {
            byte[] firstChar = new byte[]{(byte)(div - 1 + 65)};
            byte[] secondChar = new byte[]{(byte)(mod + 65)};
            String first = Rule.byteToString(firstChar);
            String second = Rule.byteToString(secondChar);
            result = first + second;
        }
        return result;
    }

    private static String byteToString(byte[] secondChar) {
        try {
            return new String(secondChar, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert char to string.", e);
        }
    }

    public List getConditions() {
        return this._conditions;
    }

    public List getConsequences() {
        return this._consequences;
    }

    public List getParameters() {
        return this._parameters;
    }

    public void setSalience(Integer value) {
        this._salience = value;
    }

    public Integer getSalience() {
        return this._salience;
    }

    public void setName(String value) {
        this._name = value;
    }

    public String getName() {
        return this._name;
    }

    public void setDuration(Duration value) {
        this._duration = value;
    }
}

