/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.drools.IntegrationException;
import org.drools.RuleBase;
import org.drools.decisiontable.SpreadsheetDRLConverter;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.io.RuleBaseLoader;
import org.xml.sax.SAXException;

public final class DecisionTableLoader {
    private DecisionTableLoader() {
        throw new UnsupportedOperationException();
    }

    public static RuleBase loadFromInputStream(InputStream streamToSpreadsheet) throws IntegrationException, SAXException, IOException {
        StringReader reader = DecisionTableLoader.getReader(streamToSpreadsheet);
        return RuleBaseLoader.loadFromReader(reader);
    }

    private static StringReader getReader(InputStream streamToSpreadsheet) {
        String generatedDrl = DecisionTableLoader.loadDRLFromStream(streamToSpreadsheet);
        StringReader reader = new StringReader(generatedDrl);
        return reader;
    }

    private static String loadDRLFromStream(InputStream streamToSpreadsheet) {
        SpreadsheetDRLConverter converter = new SpreadsheetDRLConverter();
        try {
            String generatedDrl = converter.convertToDRL(streamToSpreadsheet);
            return generatedDrl;
        }
        catch (RuntimeException e) {
            throw new DecisionTableParseException("An error occurred processing the decision table.", e);
        }
    }
}

