/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.roster;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.openvpms.archetype.rules.workflow.ScheduleEventQuery;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;

abstract class RosterEventQuery
extends ScheduleEventQuery {
    protected static final Collection<String> ROSTER_NAMES = Arrays.asList("act.archetypeId", "act.id", "act.linkId", "act.version", "act.startTime", "act.endTime", "act.details_Keys", "act.details_Values", "act.identities_Values", "act.status", "act.reason", "act.name", "participation.shortName", "participation.version", "entity.archetypeId", "entity.id", "entity.linkId", "entity.name");

    RosterEventQuery(Entity schedule, Date from, Date to, IArchetypeService service) {
        super(schedule, from, to, Collections.emptyMap(), Collections.emptyMap(), service);
    }

    @Override
    protected IArchetypeQuery createQuery(Entity schedule, Date from, Date to) {
        NamedQuery query = new NamedQuery(this.getQueryName(), ROSTER_NAMES);
        query.setParameter("scheduleId", (Object)schedule.getId());
        query.setParameter("from", (Object)from);
        query.setParameter("to", (Object)to);
        query.setMaxResults(-1);
        return query;
    }

    @Override
    protected ObjectSet createEvent(Reference actRef, ObjectSet set) {
        ObjectSet event = super.createEvent(actRef, set);
        event.set("user.objectReference", null);
        event.set("user.name", null);
        event.set("location.objectReference", null);
        event.set("location.name", null);
        event.set("synchronisation", null);
        return event;
    }

    @Override
    protected void assemble(ObjectSet target, String scheduleType, ObjectSet source) {
        super.assemble(target, scheduleType, source);
        Object value = source.get("act.identities_Values");
        if (value instanceof Identity && ((Identity)value).isA("actIdentity.sync*")) {
            HashSet<Identity> collection = (HashSet<Identity>)target.get("synchronisation");
            if (collection == null) {
                collection = new HashSet<Identity>();
                target.set("synchronisation", collection);
            }
            collection.add((Identity)value);
        }
    }

    @Override
    protected boolean populateParticipation(ObjectSet set, String archetype, Reference entityRef, String entityName, long version) {
        boolean result = true;
        if (!super.populateParticipation(set, archetype, entityRef, entityName, version)) {
            switch (archetype) {
                case "participation.rosterArea": {
                    this.populate(set, "schedule", entityRef, entityName, version);
                    break;
                }
                case "participation.location": {
                    this.populate(set, "location", entityRef, entityName, version);
                    break;
                }
                case "participation.user": {
                    this.populate(set, "user", entityRef, entityName, version);
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    protected String getScheduleType(String eventArchetype) {
        return null;
    }
}

