/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.ehcache.Cache;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.cache.DayCache;
import org.openvpms.archetype.rules.workflow.cache.DayCaches;
import org.openvpms.archetype.rules.workflow.cache.Event;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventCache {
    private final String cacheName;
    private final Cache<Key, DayCache> cache;
    private final ScheduleEventFactory factory;
    private final boolean dailyCache;
    private final Map<Long, DayCaches> cachesMap = Collections.synchronizedMap(new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK));
    private final ReferenceMap<Reference, Event> eventCache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    private static final Logger log = LoggerFactory.getLogger(AbstractEventCache.class);

    protected AbstractEventCache(EhcacheManager cacheFactory, String cacheName, ScheduleEventFactory factory, boolean dailyCache) {
        this.cacheName = cacheName;
        this.cache = cacheFactory.create(cacheName, Key.class, DayCache.class, (CacheLoaderWriter)new DayCacheLoader());
        this.factory = factory;
        this.dailyCache = dailyCache;
    }

    public ScheduleEvents getEvents(Entity entity, Date day) {
        Date from = DateRules.getDate(day);
        Date to = DateRules.getNextDate(from);
        return this.getScheduleEvents(entity, from, to);
    }

    public ScheduleEvents getEvents(Entity entity, Date from, Date to) {
        ScheduleEvents result;
        if (this.dailyCache) {
            HashCodeBuilder builder = new HashCodeBuilder();
            Date fromDay = DateRules.getDate(from);
            Date toDay = DateRules.getDate(to);
            ArrayList<PropertySet> results = new ArrayList<PropertySet>();
            while (fromDay.compareTo(toDay) <= 0) {
                ScheduleEvents dayEvents = this.getEvents(entity, fromDay);
                builder.append(dayEvents.getModHash());
                for (PropertySet event : dayEvents.getEvents()) {
                    Date actEnd;
                    Date actStart = event.getDate("act.startTime");
                    if (DateRules.intersects(actStart, actEnd = event.getDate("act.endTime"), from, to)) {
                        results.add(event);
                        continue;
                    }
                    if (DateRules.compareTo(actStart, to) < 0) continue;
                    break;
                }
                fromDay = DateRules.getDate(fromDay, 1, DateUnits.DAYS);
            }
            result = new ScheduleEvents(results, builder.toHashCode());
        } else {
            result = this.getScheduleEvents(entity, from, to);
        }
        return result;
    }

    public long getModHash(Entity entity, Date day) {
        Date from = DateRules.getDate(day);
        Date to = DateRules.getNextDate(from);
        DayCache cached = this.getDayCache(entity.getObjectReference(), from, to, entity);
        return cached != null ? cached.getModHash() : -1L;
    }

    public long getModHash(Entity entity, Date from, Date to) {
        long result;
        if (this.dailyCache) {
            HashCodeBuilder builder = new HashCodeBuilder();
            Date fromDay = DateRules.getDate(from);
            Date toDay = DateRules.getDate(to);
            boolean missing = false;
            while (fromDay.compareTo(toDay) <= 0) {
                long modHash = this.getModHash(entity, fromDay);
                if (modHash == -1L) {
                    missing = true;
                    break;
                }
                builder.append(modHash);
                fromDay = DateRules.getDate(fromDay, 1, DateUnits.DAYS);
            }
            result = missing ? -1L : (long)builder.toHashCode();
        } else {
            DayCache cached = this.getDayCache(entity.getObjectReference(), from, to, entity);
            result = cached != null ? cached.getModHash() : -1L;
        }
        return result;
    }

    public List<PropertySet> getCached(Reference entity, Date day) {
        Date from = DateRules.getDate(day);
        Date to = DateRules.getNextDate(from);
        DayCache cached = this.getDayCache(entity, day, to, null);
        return cached != null ? cached.getEvents() : null;
    }

    public void addEvent(Act event) {
        try {
            this.addEvent(this.factory.createEvent(event));
        }
        catch (Exception exception) {
            log.error("Failed to add event: " + exception.getMessage() + ". WARNING: The cache is now out of sync with the database. Event=" + event, (Throwable)exception);
        }
    }

    public void removeEvent(Act event) {
        Event e = this.removeEvent(event.getObjectReference());
        if (e != null) {
            log.debug("removeEvent: {}", (Object)e);
            DayCaches view = this.cachesMap.get(e.getEntityId());
            if (view != null) {
                view.removeEvent(e);
            } else {
                log.debug("removeEvent: Schedule not cached={}", (Object)e.getEntityId());
            }
        } else {
            log.debug("removeEvent: Event not cached={}", (Object)event.getObjectReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        log.info("Clearing cache {}", (Object)this.cacheName);
        this.cache.clear();
        this.cachesMap.clear();
        ReferenceMap<Reference, Event> referenceMap = this.eventCache;
        synchronized (referenceMap) {
            this.eventCache.clear();
        }
    }

    public Cache<?, ?> getCache() {
        return this.cache;
    }

    protected abstract Event createEvent(PropertySet var1);

    protected ScheduleEvents getScheduleEvents(Entity entity, Date from, Date to) {
        Key key = new Key(entity.getObjectReference(), from, to, entity);
        DayCache result = (DayCache)this.cache.get((Object)key);
        return result.getScheduleEvents();
    }

    protected DayCache load(Reference reference, Entity entity, Date from, Date to) {
        DayCache result = this.getDayCache(reference, from, to);
        List<PropertySet> sets = entity != null ? this.factory.getEvents(entity, from, to) : this.factory.getEvents(reference, from, to);
        List<Event> events = this.addEvents(sets);
        result.setEvents(events);
        return result;
    }

    protected DayCache getDayCache(Reference reference, Date from, Date to) {
        DayCaches caches = this.getEntity(reference);
        DayCache result = new DayCache(reference.getId(), from, to);
        caches.add(result);
        return result;
    }

    private DayCache getDayCache(Reference reference, Date from, Date to, Entity entity) {
        DayCache result = null;
        Key key = new Key(reference, from, to, entity);
        if (this.cache.containsKey((Object)key)) {
            result = (DayCache)this.cache.get((Object)key);
        }
        return result;
    }

    private void addEvent(PropertySet set) {
        DayCaches caches;
        DayCaches oldView;
        Event[] events = this.update(set);
        Event oldEvent = events[0];
        Event newEvent = events[1];
        log.debug("addEvent: old=[{}], new=[{}]", (Object)oldEvent, (Object)newEvent);
        if (oldEvent != null && (oldView = this.cachesMap.get(oldEvent.getEntityId())) != null) {
            oldView.removeEvent(oldEvent);
        }
        if ((caches = this.cachesMap.get(newEvent.getEntityId())) != null) {
            caches.addEvent(newEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DayCaches getEntity(Reference reference) {
        DayCaches result;
        Map<Long, DayCaches> map = this.cachesMap;
        synchronized (map) {
            long id = reference.getId();
            result = this.cachesMap.computeIfAbsent(id, l -> new DayCaches(id));
        }
        return result;
    }

    private List<Event> addEvents(List<PropertySet> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (PropertySet set : events) {
            Event event = this.update(set)[1];
            result.add(event);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event[] update(PropertySet set) {
        Event[] result = new Event[2];
        IMObjectReference act = set.getReference("act.objectReference");
        ReferenceMap<Reference, Event> referenceMap = this.eventCache;
        synchronized (referenceMap) {
            Event event = (Event)this.eventCache.get((Object)act);
            if (event == null) {
                event = this.createEvent(set);
                this.eventCache.put((Object)act, (Object)event);
            } else {
                result[0] = this.createEvent(event.getEvent());
                event.update(set);
            }
            result[1] = event;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event removeEvent(Reference act) {
        Event result;
        ReferenceMap<Reference, Event> referenceMap = this.eventCache;
        synchronized (referenceMap) {
            result = (Event)this.eventCache.remove((Object)act);
        }
        return result;
    }

    private static class Key {
        private final Reference reference;
        private final Date from;
        private final Date to;
        private final Entity entity;
        private final int hashCode;

        Key(Reference reference, Date from, Date to, Entity entity) {
            this.reference = reference;
            this.from = from;
            this.to = to;
            this.entity = entity;
            long id = reference.getId();
            this.hashCode = (int)(id ^ id >>> 32) ^ from.hashCode() ^ to.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.reference.getId() == other.reference.getId() && this.from.equals(other.from) && this.to.equals(other.to);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class DayCacheLoader
    implements CacheLoaderWriter<Key, DayCache> {
        private DayCacheLoader() {
        }

        public DayCache load(Key key) {
            Entity entity = key.entity;
            Date from = key.from;
            Date to = key.to;
            Reference reference = key.reference;
            return AbstractEventCache.this.load(reference, entity, from, to);
        }

        public void write(Key key, DayCache value) {
        }

        public void delete(Key key) {
        }
    }
}

