/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.basic.TypedValue;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;

public abstract class ScheduleEventQuery {
    private final IArchetypeService service;
    private final Map<String, String> statusNames;
    private final Map<String, String> reasonNames;
    private final Entity schedule;
    private final Date from;
    private final Date to;
    private static final String ACT_ID = "act.id";
    protected static final Collection<String> NAMES = Arrays.asList("act.archetypeId", "act.id", "act.linkId", "act.version", "act.startTime", "act.endTime", "act.details_Keys", "act.details_Values", "act.status", "act.reason", "act.name", "participation.shortName", "participation.version", "entity.archetypeId", "entity.id", "entity.linkId", "entity.name");

    protected ScheduleEventQuery(Entity schedule, Date from, Date to, Map<String, String> statusNames, Map<String, String> reasonNames, IArchetypeService service) {
        this.schedule = schedule;
        this.from = from;
        this.to = to;
        this.service = service;
        this.statusNames = statusNames;
        this.reasonNames = reasonNames;
    }

    public IPage<ObjectSet> query() {
        IArchetypeQuery query = this.createQuery(this.schedule, this.from, this.to);
        List<ObjectSet> page = this.query(query);
        ArrayList<ObjectSet> result = new ArrayList<ObjectSet>();
        Reference currentAct = null;
        ObjectSet current = null;
        String scheduleType = null;
        for (ObjectSet set : page) {
            Reference actRef = this.getAct(set);
            if (currentAct == null || !currentAct.equals((Object)actRef)) {
                if (current != null) {
                    result.add(current);
                }
                currentAct = actRef;
                current = this.createEvent(actRef, set);
                scheduleType = this.getScheduleType(actRef.getArchetype());
                current.set("act.version", (Object)set.getLong("act.version"));
            }
            this.assemble(current, scheduleType, set);
        }
        if (current != null) {
            result.add(current);
        }
        return new Page(result, 0, result.size(), result.size());
    }

    protected void assemble(ObjectSet target, String scheduleType, ObjectSet source) {
        long version;
        String entityName;
        Reference entityRef = this.getEntity(source);
        String participation = source.getString("participation.shortName");
        if (!this.populateParticipation(target, participation, entityRef, entityName = source.getString("entity.name"), version = source.getLong("participation.version")) && scheduleType != null && entityRef.isA(scheduleType)) {
            this.populate(target, "scheduleType", entityRef, entityName, version);
        }
        String key = source.getString("act.details_Keys");
        TypedValue value = (TypedValue)source.get("act.details_Values");
        if (key != null) {
            Object object = value != null ? value.getObject() : null;
            target.set(key, object);
        }
    }

    protected abstract String getQueryName();

    protected abstract String getScheduleType(String var1);

    protected IArchetypeQuery createQuery(Entity schedule, Date from, Date to) {
        NamedQuery query = new NamedQuery(this.getQueryName(), NAMES);
        query.setParameter("scheduleId", (Object)schedule.getId());
        query.setParameter("from", (Object)from);
        query.setParameter("to", (Object)to);
        query.setMaxResults(-1);
        return query;
    }

    protected ObjectSet createEvent(Reference actRef, ObjectSet set) {
        ObjectSet result = new ObjectSet();
        String status = set.getString("act.status");
        String reason = set.getString("act.reason");
        result.set("act.objectReference", (Object)actRef);
        result.set("act.startTime", set.get("act.startTime"));
        result.set("act.endTime", set.get("act.endTime"));
        result.set("act.status", (Object)status);
        result.set("act.statusName", (Object)this.statusNames.get(status));
        result.set("act.reason", (Object)reason);
        result.set("act.reasonName", (Object)this.reasonNames.get(reason));
        result.set("act.name", set.get("act.name"));
        result.set("notes", null);
        result.set("customer.objectReference", null);
        result.set("customer.name", null);
        result.set("patient.objectReference", null);
        result.set("patient.name", null);
        result.set("schedule.objectReference", null);
        result.set("schedule.name", null);
        result.set("scheduleType.objectReference", null);
        result.set("scheduleType.name", null);
        result.set("clinician.objectReference", null);
        result.set("clinician.name", null);
        result.set("confirmedTime", null);
        result.set("arrivalTime", null);
        return result;
    }

    protected boolean populateParticipation(ObjectSet set, String archetype, Reference entityRef, String entityName, long version) {
        boolean populated = true;
        if ("participation.schedule".equals(archetype)) {
            this.populate(set, "schedule", entityRef, entityName, version);
        } else if ("participation.customer".equals(archetype)) {
            this.populate(set, "customer", entityRef, entityName, version);
        } else if ("participation.patient".equals(archetype)) {
            this.populate(set, "patient", entityRef, entityName, version);
        } else if ("participation.clinician".equals(archetype)) {
            this.populate(set, "clinician", entityRef, entityName, version);
        } else {
            populated = false;
        }
        return populated;
    }

    protected void populate(ObjectSet set, String prefix, Reference entityRef, String entityName, long version) {
        set.set(prefix + ".objectReference", (Object)entityRef);
        set.set(prefix + ".name", (Object)entityName);
        set.set(prefix + "Participation.version", (Object)version);
    }

    private List<ObjectSet> query(IArchetypeQuery query) {
        IPage page = this.service.getObjects(query);
        List results = page.getResults();
        if (!results.isEmpty()) {
            results = results.stream().sorted((o1, o2) -> {
                long id2;
                long id1 = o1.getLong(ACT_ID);
                int result = Long.compare(id1, id2 = o2.getLong(ACT_ID));
                if (result == 0) {
                    Date date1 = o1.getDate("act.startTime");
                    Date date2 = o2.getDate("act.startTime");
                    result = DateRules.compareTo(date1, date2);
                }
                return result;
            }).collect(Collectors.toList());
        }
        return results;
    }

    private Reference getAct(ObjectSet set) {
        ArchetypeId archetypeId = (ArchetypeId)set.get("act.archetypeId");
        long id = set.getLong(ACT_ID);
        String linkId = set.getString("act.linkId");
        return new IMObjectReference(archetypeId, id, linkId);
    }

    private Reference getEntity(ObjectSet set) {
        ArchetypeId archetypeId = (ArchetypeId)set.get("entity.archetypeId");
        long id = set.getLong("entity.id");
        String linkId = set.getString("entity.linkId");
        return new IMObjectReference(archetypeId, id, linkId);
    }
}

