/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.Reference;

public class ProductData {
    private final long id;
    private final String name;
    private final int line;
    private String printedName;
    private BigDecimal taxRate;
    private List<PriceData> fixedPrices = new ArrayList<PriceData>();
    private List<PriceData> unitPrices = new ArrayList<PriceData>();
    private Reference reference;
    private String error;
    private int errorLine;

    public ProductData(long id, String name, String printedName, BigDecimal taxRate, int line) {
        this.id = id;
        this.name = name;
        this.printedName = printedName;
        this.taxRate = taxRate;
        this.line = line;
    }

    public ProductData(ProductData source) {
        this.id = source.getId();
        this.name = source.getName();
        this.printedName = source.getPrintedName();
        this.taxRate = source.getTaxRate();
        this.line = source.getLine();
        this.reference = source.getReference();
    }

    public long getId() {
        return this.id;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public String getPrintedName() {
        return this.printedName;
    }

    public void setPrintedName(String printedName) {
        this.printedName = printedName;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void addPrice(PriceData price) {
        if ("productPrice.fixedPrice".equals(price.getShortName())) {
            this.fixedPrices.add(price);
        } else {
            this.unitPrices.add(price);
        }
    }

    public void addFixedPrice(long id, BigDecimal price, BigDecimal cost, BigDecimal maxDiscount, Date from, Date to, boolean defaultPrice, Set<Lookup> groups, int line) {
        this.fixedPrices.add(new PriceData(id, "productPrice.fixedPrice", price, cost, maxDiscount, from, to, defaultPrice, groups, line));
    }

    public void addUnitPrice(long id, BigDecimal price, BigDecimal cost, BigDecimal maxDiscount, Date from, Date to, Set<Lookup> groups, int line) {
        this.unitPrices.add(new PriceData(id, "productPrice.unitPrice", price, cost, maxDiscount, from, to, groups, line));
    }

    public List<PriceData> getFixedPrices() {
        return this.fixedPrices;
    }

    public List<PriceData> getUnitPrices() {
        return this.unitPrices;
    }

    public int getLine() {
        return this.line;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error, int line) {
        this.error = error;
        this.errorLine = line;
    }

    public int getErrorLine() {
        return this.errorLine;
    }
}

