/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.archetype.rules.prefs.Preferences;

public class PreferenceMonitor {
    private final Preferences preferences;
    private Map<Id, Object> values = new HashMap<Id, Object>();

    public PreferenceMonitor(Preferences preferences) {
        this.preferences = preferences;
    }

    public void add(String group) {
        for (String name : this.preferences.getNames(group)) {
            this.add(group, name);
        }
    }

    public void add(String group, String name) {
        Id id = new Id(group, name);
        this.values.put(id, this.getValue(id));
    }

    public boolean changed() {
        boolean result = false;
        for (Map.Entry<Id, Object> entry : this.values.entrySet()) {
            Id id = entry.getKey();
            Object current = this.getValue(id);
            if (Objects.equals(entry.getValue(), current)) continue;
            entry.setValue(current);
            result = true;
        }
        return result;
    }

    protected Object getValue(Id id) {
        return this.preferences.getPreference(id.group, id.name, null);
    }

    private static class Id {
        public final String group;
        public final String name;

        public Id(String group, String name) {
            this.group = group;
            this.name = name;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Id) {
                return this.group.equals(((Id)object).group) && this.name.equals(((Id)object).name);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.group).append((Object)this.name).toHashCode();
        }

        public String toString() {
            return this.group + "/" + this.name;
        }
    }
}

