/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.HashSet;
import java.util.Set;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.AbstractNodePropertySet;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.AbstractPropertySet;

class PreferenceGroup
extends AbstractPropertySet {
    private final IArchetypeService service;
    private final NodePropertySet properties;

    public PreferenceGroup(Entity entity, IArchetypeService service) {
        this.service = service;
        this.properties = new NodePropertySet(entity);
    }

    public Set<String> getNames() {
        return this.properties.getNames();
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    public void set(String name, Object value) {
        this.properties.set(name, value);
    }

    public void save() {
        this.service.save((org.openvpms.component.model.object.IMObject)this.properties.getObject());
    }

    public Entity getEntity() {
        return (Entity)this.properties.getObject();
    }

    private class NodePropertySet
    extends AbstractNodePropertySet {
        public NodePropertySet(Entity object) {
            super((IMObject)object);
        }

        public Set<String> getNames() {
            HashSet<String> result = new HashSet<String>();
            for (NodeDescriptor descriptor : this.getArchetype().getSimpleNodeDescriptors()) {
                if (descriptor.isHidden() || descriptor.isReadOnly() || descriptor.isDerived()) continue;
                result.add(descriptor.getName());
            }
            return result;
        }

        protected IArchetypeService getArchetypeService() {
            return PreferenceGroup.this.service;
        }
    }
}

