/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;

public class Reminders {
    private final List<ReminderEvent> reminders;
    private final ReminderType.GroupBy groupBy;

    public Reminders(ReminderEvent reminder) {
        this(Collections.singletonList(reminder), ReminderType.GroupBy.NONE);
    }

    public Reminders(List<ReminderEvent> reminders, ReminderType.GroupBy groupBy) {
        this.reminders = reminders;
        this.groupBy = groupBy;
    }

    public List<ReminderEvent> getReminders() {
        return this.reminders;
    }

    public ReminderType.GroupBy getGroupBy() {
        return this.groupBy;
    }

    public boolean contains(Act item) {
        return Reminders.contains(item, this.reminders);
    }

    public static boolean contains(Act item, List<ReminderEvent> reminders) {
        return Reminders.find(item, reminders) != null;
    }

    public static ReminderEvent find(Act item, List<ReminderEvent> reminders) {
        Reference reference = item.getObjectReference();
        for (ReminderEvent event : reminders) {
            Act act = event.getItem();
            if (!act.getObjectReference().equals((Object)reference)) continue;
            return event;
        }
        return null;
    }

    public static Act findItem(Act item, List<ReminderEvent> reminders) {
        ReminderEvent event = Reminders.find(item, reminders);
        return event != null ? event.getItem() : null;
    }
}

