/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;

public class PatientHistory {
    private final IArchetypeService service;
    private static final String[] PRODUCTS = new String[]{"product.medication", "product.service", "product.merchandise"};
    private static final String START_TIME = "startTime";

    public PatientHistory(IArchetypeService service) {
        this.service = service;
    }

    public Iterable<Act> getCharges(Party patient) {
        return this.getCharges(patient, null, null, null);
    }

    public Iterable<Act> getCharges(Party patient, Date from, Date to) {
        return this.getCharges(patient, null, from, to);
    }

    public Iterable<Act> getCharges(Party patient, String productTypeName) {
        return this.getCharges(patient, productTypeName, null, null);
    }

    public Iterable<Act> getCharges(Party patient, String productTypeName, Date from, Date to) {
        return this.createQuery(patient, "act.customerAccountInvoiceItem", productTypeName, from, to);
    }

    public Iterable<Act> getMedication(Party patient) {
        ArchetypeQuery query = this.createQuery(patient, "act.patientMedication");
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Iterable<Act> getMedication(Party patient, Date from, Date to) {
        return this.getMedication(patient, null, from, to);
    }

    public Iterable<Act> getMedication(Party patient, String productTypeName) {
        return this.getMedication(patient, productTypeName, null, null);
    }

    public Iterable<Act> getMedication(Party patient, String productTypeName, Date from, Date to) {
        return this.createQuery(patient, "act.patientMedication", productTypeName, from, to);
    }

    protected Iterable<Act> createQuery(Party patient, String shortName, String productTypeName, Date from, Date to) {
        ArchetypeQuery query = this.createQuery(patient, shortName);
        if (productTypeName != null) {
            query.add((IConstraint)Constraints.join((String)"product", (String)"p1"));
            query.add((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String[])PRODUCTS, (String)"p2").add((IConstraint)Constraints.join((String)"type").add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.eq((String)"name", (Object)productTypeName)).add((IConstraint)Constraints.idEq((String)"p1.entity", (String)"p2"))))));
        }
        if (from != null || to != null) {
            if (from != null && to != null) {
                query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)from));
                query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)to));
            } else if (from == null) {
                query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)to));
            } else {
                query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)from));
            }
        }
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    private ArchetypeQuery createQuery(Party patient, String shortName) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"act", (String)shortName));
        JoinConstraint participation = Constraints.join((String)"patient");
        participation.add((IConstraint)Constraints.eq((String)"entity", (Object)patient));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)shortName));
        query.add((IConstraint)participation);
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        return query;
    }
}

