/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyMerger;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.RelationalOp;

class CustomerMerger
extends PartyMerger {
    private final CustomerRules rules;
    private static final String PRACTICE = "practice";
    private static final String CUSTOMER_LOCATION = "entityLink.customerLocation";

    CustomerMerger(IArchetypeService service, CustomerRules rules) {
        super("party.customerperson", service);
        this.rules = rules;
    }

    @Override
    protected List<IMObject> moveParticipations(Party from, Party to) {
        Date startTime;
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        ArchetypeQuery fromQuery = this.createOpeningClosingBalanceQuery(from);
        if (this.remove(fromQuery) && (startTime = this.getFirstTransactionStartTime(from)) != null) {
            ArchetypeQuery toQuery = this.createOpeningClosingBalanceQuery(to);
            toQuery.add((IConstraint)new NodeConstraint("startTime", RelationalOp.GTE, new Object[]{startTime}));
            toQuery.setMaxResults(-1);
            this.remove(toQuery);
        }
        Reference fromRef = from.getObjectReference();
        Reference toRef = to.getObjectReference();
        ArchetypeQuery query = new ArchetypeQuery("participation.*", true, false);
        query.add((IConstraint)new ObjectRefNodeConstraint("entity", fromRef));
        query.setMaxResults(-1);
        List participations = this.getArchetypeService().get((IArchetypeQuery)query).getResults();
        for (IMObject object : participations) {
            Participation participation = (Participation)object;
            if (TypeHelper.isA((Reference)participation.getAct(), (String[])new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"})) continue;
            participation.setEntity(toRef);
            result.add((IMObject)participation);
        }
        return result;
    }

    @Override
    protected void copyClassifications(Party from, Party to) {
        for (Lookup lookup : from.getClassifications()) {
            if (lookup.isA("lookup.customerAccountType")) continue;
            to.addClassification(lookup);
        }
        Lookup accountType = this.rules.getAccountTypeLookup(to);
        if (accountType == null && (accountType = this.rules.getAccountTypeLookup(from)) != null) {
            to.addClassification(accountType);
        }
    }

    @Override
    protected void copyEntityLinks(Party from, Party to) {
        IMObjectBean fromBean;
        Reference practice;
        super.copyEntityLinks(from, to);
        IArchetypeService service = this.getArchetypeService();
        IMObjectBean toBean = service.getBean((IMObject)to);
        if (toBean.getTargetRef(PRACTICE) == null && (practice = (fromBean = service.getBean((IMObject)from)).getTargetRef(PRACTICE)) != null) {
            toBean.setTarget(PRACTICE, practice);
        }
    }

    @Override
    protected Set<EntityLink> getEntityLinks(Party from) {
        Set<EntityLink> links = super.getEntityLinks(from);
        return links.stream().filter(Predicates.isA((String[])new String[]{CUSTOMER_LOCATION}).negate()).collect(Collectors.toSet());
    }

    private boolean remove(ArchetypeQuery query) {
        boolean removed = false;
        IArchetypeService service = this.getArchetypeService();
        IMObjectQueryIterator iter = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        while (iter.hasNext()) {
            service.remove((IMObject)iter.next());
            removed = true;
        }
        return removed;
    }

    private Date getFirstTransactionStartTime(Party party) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createObjectSetQuery(party, CustomerAccountArchetypes.DEBITS_CREDITS, true);
        query.add((IConstraint)new NodeSelectConstraint("act.startTime"));
        query.setMaxResults(1);
        Date startTime = null;
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.getArchetypeService(), (IArchetypeQuery)query);
        if (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            startTime = (Date)set.get("act.startTime");
        }
        return startTime;
    }

    private ArchetypeQuery createOpeningClosingBalanceQuery(Party party) {
        String[] shortNames = new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"};
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(party, shortNames);
        query.setMaxResults(-1);
        return query;
    }
}

