/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.CurrencyException;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.springframework.beans.factory.DisposableBean;

public class Currencies
implements DisposableBean {
    public static final String LOOKUP = "lookup.currency";
    private final IArchetypeService service;
    private final LookupService lookupService;
    private final Map<String, Currency> cache = new HashMap<String, Currency>();
    private final AbstractArchetypeServiceListener listener;

    public Currencies(IArchetypeService service, LookupService lookupService) {
        this.service = service;
        this.lookupService = lookupService;
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                Currencies.this.add((Lookup)object);
            }

            public void removed(IMObject object) {
                Currencies.this.delete((Lookup)object);
            }
        };
        service.addListener(LOOKUP, (IArchetypeServiceListener)this.listener);
    }

    public synchronized Currency getCurrency(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new CurrencyException(CurrencyException.ErrorCode.InvalidCurrencyCode, code);
        }
        Currency currency = this.cache.get(code);
        if (currency == null) {
            Lookup lookup = this.lookupService.getLookup(LOOKUP, code);
            if (lookup == null) {
                throw new CurrencyException(CurrencyException.ErrorCode.NoLookupForCode, code);
            }
            currency = this.add(lookup);
        }
        return currency;
    }

    public void destroy() {
        this.service.removeListener(LOOKUP, (IArchetypeServiceListener)this.listener);
    }

    private synchronized Currency add(Lookup lookup) {
        Currency currency = new Currency(lookup, this.service);
        this.cache.put(lookup.getCode(), currency);
        return currency;
    }

    private synchronized void delete(Lookup lookup) {
        this.cache.remove(lookup.getCode());
    }
}

