/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.credit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.archetype.rules.finance.credit.AllocationBlock;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.archetype.rules.finance.credit.GapClaimAllocationBlock;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class CreditActAllocator {
    private final IArchetypeService service;
    private final InsuranceRules insuranceRules;
    private final BalanceCalculator calculator;
    private final CustomerBalanceUpdater updater;

    public CreditActAllocator(IArchetypeService service, InsuranceRules insuranceRules) {
        this.service = service;
        this.insuranceRules = insuranceRules;
        this.calculator = new BalanceCalculator(service);
        this.updater = new CustomerBalanceUpdater(service, insuranceRules);
    }

    public CreditAllocation allocate(FinancialAct credit) {
        return this.allocate(credit, Collections.emptyList(), false);
    }

    public CreditAllocation allocate(FinancialAct credit, List<FinancialAct> debits, boolean partialAllocation) {
        CreditAllocation result;
        if (!credit.isCredit()) {
            throw new IllegalArgumentException("Argument 'credit' must be a credit");
        }
        if (!debits.isEmpty()) {
            this.checkDebits(debits);
        }
        if ("POSTED".equals(credit.getStatus()) && !this.calculator.isAllocated(credit)) {
            BigDecimal amountToAllocate = this.calculator.getAllocatable(credit);
            IMObjectBean bean = this.service.getBean((IMObject)credit);
            Reference customer = bean.getTargetRef("customer");
            if (customer == null) {
                throw new IllegalStateException("Failed to determine customer for " + credit.getArchetype());
            }
            ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedQuery(customer, CustomerAccountArchetypes.DEBITS, null);
            ArrayList<FinancialAct> allUnallocated = new ArrayList<FinancialAct>(debits);
            query.setMaxResults(-1);
            IMObjectQueryIterator saved = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
            while (saved.hasNext()) {
                FinancialAct act = (FinancialAct)saved.next();
                if (allUnallocated.contains(act)) continue;
                allUnallocated.add(act);
            }
            if (allUnallocated.isEmpty()) {
                result = new CreditAllocation(credit, (ArchetypeService)this.service);
            } else {
                LinkedHashMap<FinancialAct, AllocationBlock> blocked = new LinkedHashMap<FinancialAct, AllocationBlock>();
                List<FinancialAct> toAllocate = this.getAllocatable(allUnallocated, debits, blocked);
                if (blocked.isEmpty() && debits.isEmpty()) {
                    result = new CreditAllocation(credit, toAllocate, (ArchetypeService)this.service);
                } else {
                    BigDecimal unallocated = BigDecimal.ZERO;
                    for (FinancialAct act : toAllocate) {
                        BigDecimal allocatable = this.calculator.getAllocatable(act);
                        unallocated = unallocated.add(allocatable);
                    }
                    if (unallocated.compareTo(amountToAllocate) >= 0 || partialAllocation && unallocated.compareTo(BigDecimal.ZERO) > 0) {
                        this.updater.addToBalance(credit);
                        for (FinancialAct act : toAllocate) {
                            this.updater.addToBalance(act);
                        }
                        List<FinancialAct> updated = this.updater.updateBalance(credit, toAllocate.iterator(), false);
                        result = new CreditAllocation(credit, toAllocate, blocked, updated, (ArchetypeService)this.service);
                    } else {
                        ArrayList<FinancialAct> unallocatedDebits = new ArrayList<FinancialAct>(toAllocate);
                        unallocatedDebits.addAll(blocked.keySet());
                        result = new CreditAllocation(credit, unallocatedDebits, blocked, (ArchetypeService)this.service);
                    }
                }
            }
        } else {
            result = new CreditAllocation(credit, (ArchetypeService)this.service);
        }
        return result;
    }

    public List<FinancialAct> allocate(FinancialAct credit, FinancialAct debit) {
        return this.allocate(credit, Collections.singletonList(debit));
    }

    public List<FinancialAct> allocate(FinancialAct credit, List<FinancialAct> debits) {
        List<FinancialAct> result = Collections.emptyList();
        if (!credit.isCredit()) {
            throw new IllegalArgumentException("Argument 'credit' must be a credit");
        }
        if (!"POSTED".equals(credit.getStatus())) {
            throw new IllegalArgumentException("Argument 'credit' must be POSTED");
        }
        this.checkDebits(debits);
        if ("POSTED".equals(credit.getStatus()) && !this.calculator.isAllocated(credit)) {
            IMObjectBean bean = this.service.getBean((IMObject)credit);
            Party customer = (Party)bean.getTarget("customer", Party.class);
            if (customer == null) {
                throw new IllegalStateException("Failed to determine customer for " + credit.getArchetype());
            }
            this.updater.addToBalance(credit);
            for (FinancialAct debit : debits) {
                this.updater.addToBalance(debit);
            }
            result = this.updater.updateBalance(credit, debits.iterator(), false);
        }
        return result;
    }

    protected List<FinancialAct> getAllocatable(List<FinancialAct> unallocated, List<FinancialAct> debits, Map<FinancialAct, AllocationBlock> blocked) {
        ArrayList<FinancialAct> toAllocate = new ArrayList<FinancialAct>();
        for (FinancialAct act : unallocated) {
            if (!debits.contains(act)) {
                AllocationBlock block = this.getAllocationBlock(act);
                if (block != null) {
                    blocked.put(act, block);
                    continue;
                }
                toAllocate.add(act);
                continue;
            }
            toAllocate.add(act);
        }
        return toAllocate;
    }

    protected AllocationBlock getAllocationBlock(FinancialAct debit) {
        List<FinancialAct> claims;
        GapClaimAllocationBlock result = null;
        if (debit.isA("act.customerAccountChargesInvoice") && !(claims = this.insuranceRules.getCurrentGapClaims(debit)).isEmpty()) {
            result = new GapClaimAllocationBlock(claims);
        }
        return result;
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    private void checkDebits(List<FinancialAct> debits) {
        for (FinancialAct debit : debits) {
            if (debit.isCredit()) {
                throw new IllegalArgumentException("Argument 'debits' must contain a list of debit acts");
            }
            if ("POSTED".equals(debit.getStatus())) continue;
            throw new IllegalArgumentException("Argument 'debits' must contain a list of POSTED debit acts");
        }
    }
}

