/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TransactionRules {
    private final ArchetypeService service;
    private static final String ITEMS = "items";

    public TransactionRules(ArchetypeService service) {
        this.service = service;
    }

    public boolean hasApprovedEFTPOSTransaction(FinancialAct act) {
        boolean result = false;
        List<FinancialAct> items = this.getEFTItems(act);
        for (FinancialAct item : items) {
            if (!this.itemHasApprovedEFTPOSTransaction(item)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean itemHasApprovedEFTPOSTransaction(FinancialAct item) {
        boolean result = false;
        if (item.isA(new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"})) {
            FinancialAct latest = this.getMostRecentTransaction(item);
            result = latest != null && "APPROVED".equals(latest.getStatus());
        }
        return result;
    }

    public FinancialAct getMostRecentTransaction(FinancialAct item) {
        List transactions = this.service.getBean((IMObject)item).getTargets("transactions", FinancialAct.class, Policies.orderBySequence((boolean)false));
        return !transactions.isEmpty() ? (FinancialAct)transactions.get(0) : null;
    }

    public List<FinancialAct> getEFTItems(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.getTargets(ITEMS, FinancialAct.class, Policies.all((Predicate)Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"})));
    }

    public List<FinancialAct> getPaymentProcessorItems(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.getTargets(ITEMS, FinancialAct.class, Policies.all((Predicate)Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"})));
    }

    public ItemStatus getEFTPOSTransactionStatus(FinancialAct act, boolean ignoreUnsuccessful) {
        FinancialAct item;
        FinancialAct latest;
        ItemStatus result = new ItemStatus(ItemStatus.Status.NO_TRANSACTION);
        Iterator<FinancialAct> iterator = this.getEFTItems(act).iterator();
        while (iterator.hasNext() && (latest = this.getMostRecentTransaction(item = iterator.next())) != null) {
            String status = latest.getStatus();
            if ("PENDING".equals(status) || "IN_PROGRESS".equals(status)) {
                result = new ItemStatus(ItemStatus.Status.INCOMPLETE, item, latest);
                continue;
            }
            if ("APPROVED".equals(status) || "NO_TERMINAL".equals(status)) {
                result = new ItemStatus(ItemStatus.Status.COMPLETE, item, latest);
                continue;
            }
            if (ignoreUnsuccessful) continue;
            result = new ItemStatus(ItemStatus.Status.INCOMPLETE, item, latest);
        }
        return result;
    }

    public ItemStatus getPaymentProcessorTransactionStatus(FinancialAct act, boolean ignoreUnsuccessful) {
        ItemStatus result = new ItemStatus(ItemStatus.Status.NO_TRANSACTION);
        for (FinancialAct item : this.getPaymentProcessorItems(act)) {
            FinancialAct latest = this.getMostRecentTransaction(item);
            if (latest == null) {
                result = new ItemStatus(ItemStatus.Status.UNSUBMITTED, item, null);
                break;
            }
            String status = latest.getStatus();
            if ("PENDING".equals(status) || "IN_PROGRESS".equals(status)) {
                result = new ItemStatus(ItemStatus.Status.UNSUBMITTED, item, latest);
                break;
            }
            if ("SUBMITTED".equals(status)) {
                result = new ItemStatus(ItemStatus.Status.INCOMPLETE, item, latest);
                break;
            }
            if ("COMPLETED".equals(status)) {
                result = new ItemStatus(ItemStatus.Status.COMPLETE);
                continue;
            }
            if (ignoreUnsuccessful) continue;
            result = new ItemStatus(ItemStatus.Status.UNSUBMITTED, item, latest);
            break;
        }
        return result;
    }

    public static class ItemStatus {
        private final Status status;
        private final FinancialAct item;
        private final FinancialAct transaction;

        public ItemStatus(Status status) {
            this(status, null, null);
        }

        public ItemStatus(Status status, FinancialAct item, FinancialAct transaction) {
            this.status = status;
            this.item = item;
            this.transaction = transaction;
        }

        public boolean isUnsubmitted() {
            return this.status == Status.UNSUBMITTED;
        }

        public boolean isIncomplete() {
            return this.status == Status.INCOMPLETE;
        }

        public boolean isComplete() {
            return this.status == Status.COMPLETE;
        }

        public Status getStatus() {
            return this.status;
        }

        public FinancialAct getItem() {
            return this.item;
        }

        public FinancialAct getTransaction() {
            return this.transaction;
        }

        public static enum Status {
            NO_TRANSACTION,
            UNSUBMITTED,
            INCOMPLETE,
            COMPLETE;

        }
    }
}

