/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.List;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class CustomerAccountQueryFactory {
    private static final String ID = "id";
    private static final String START_TIME = "startTime";
    private static final String STATUS = "status";
    private static final String AMOUNT = "amount";
    private static final String ALLOCATED_AMOUNT = "allocatedAmount";
    private static final String CREDIT = "credit";

    private CustomerAccountQueryFactory() {
    }

    public static ArchetypeQuery createUnallocatedObjectSetQuery(Party customer, List<String> archetypes) {
        return CustomerAccountQueryFactory.createUnallocatedObjectSetQuery(customer, archetypes.toArray(new String[0]));
    }

    public static ArchetypeQuery createUnallocatedObjectSetQuery(Party customer, String[] shortNames) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedQuery(customer, shortNames, null);
        query.add((IConstraint)new NodeSelectConstraint(AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(ALLOCATED_AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(CREDIT));
        return query;
    }

    public static ArchetypeQuery createUnallocatedQuery(Party customer, String[] shortNames, Act exclude) {
        return CustomerAccountQueryFactory.createUnallocatedQuery(customer.getObjectReference(), shortNames, exclude);
    }

    public static ArchetypeQuery createUnallocatedQuery(Reference customer, List<String> archetypes, Act exclude) {
        return CustomerAccountQueryFactory.createUnallocatedQuery(customer, archetypes.toArray(new String[0]), exclude);
    }

    public static ArchetypeQuery createUnallocatedQuery(Reference customer, String[] shortNames, Act exclude) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createBalanceParticipationQuery(customer, shortNames, exclude);
        query.add((IConstraint)Constraints.eq((String)STATUS, (Object)"POSTED"));
        return query;
    }

    public static ArchetypeQuery createUnbilledObjectSetQuery(Party customer, String[] shortNames) {
        return CustomerAccountQueryFactory.createUnbilledObjectSetQuery(customer.getObjectReference(), shortNames);
    }

    public static ArchetypeQuery createUnbilledObjectSetQuery(Reference customer, String[] shortNames) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createBalanceParticipationQuery(customer, shortNames, null);
        query.add((IConstraint)Constraints.ne((String)STATUS, (Object)"POSTED"));
        query.add((IConstraint)new NodeSelectConstraint(AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(ALLOCATED_AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(CREDIT));
        return query;
    }

    public static ArchetypeQuery createObjectSetQuery(Party customer, List<String> archetypes, boolean sortAscending) {
        return CustomerAccountQueryFactory.createObjectSetQuery(customer, archetypes.toArray(new String[0]), sortAscending);
    }

    public static ArchetypeQuery createObjectSetQuery(Party customer, String[] shortNames, boolean sortAscending) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, shortNames);
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)sortAscending));
        query.add((IConstraint)Constraints.sort((String)ID, (boolean)true));
        query.add((IConstraint)new NodeSelectConstraint(AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(ALLOCATED_AMOUNT));
        query.add((IConstraint)new NodeSelectConstraint(CREDIT));
        return query;
    }

    public static ArchetypeQuery createQuery(Party customer, String archetype) {
        return CustomerAccountQueryFactory.createQuery(customer.getObjectReference(), new String[]{archetype});
    }

    public static ArchetypeQuery createQuery(Party customer, List<String> archetypes) {
        return CustomerAccountQueryFactory.createQuery(customer.getObjectReference(), archetypes.toArray(new String[0]));
    }

    public static ArchetypeQuery createQuery(Party customer, String[] shortNames) {
        return CustomerAccountQueryFactory.createQuery(customer.getObjectReference(), shortNames);
    }

    public static ArchetypeQuery createQuery(Reference customer, List<String> shortNames) {
        return CustomerAccountQueryFactory.createQuery(customer, shortNames.toArray(new String[0]));
    }

    public static ArchetypeQuery createQuery(Reference customer, String[] shortNames) {
        ShortNameConstraint archetypes = Constraints.shortName((String)"act", (String[])shortNames, (boolean)false);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)archetypes);
        JoinConstraint join = Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)"entity", (Reference)customer));
        OrConstraint or = new OrConstraint();
        for (String shortName : shortNames) {
            ArchetypeId id = new ArchetypeId(shortName);
            or.add((IConstraint)Constraints.eq((String)"customer.act", (ArchetypeId)id));
        }
        query.add((IConstraint)join);
        query.add((IConstraint)or);
        return query;
    }

    private static ArchetypeQuery createBalanceParticipationQuery(Reference customer, String[] shortNames, Act exclude) {
        ShortNameConstraint archetypes = Constraints.shortName((String)"act", (String[])shortNames, (boolean)false);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)archetypes);
        JoinConstraint join = Constraints.join((String)"accountBalance").add((IConstraint)Constraints.eq((String)"entity", (Reference)customer));
        if (exclude != null) {
            join.add((IConstraint)Constraints.ne((String)"act", (Object)exclude));
        }
        query.add((IConstraint)join);
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)ID));
        return query;
    }
}

