/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;

class LogoCache
extends MonitoringIMObjectCache<DocumentAct> {
    private final DocumentRules rules;
    private final Map<Reference, DocumentAct> logos = Collections.synchronizedMap(new HashMap());

    public LogoCache(IArchetypeService service, DocumentRules rules, boolean load) {
        super(service, "act.documentLogo", DocumentAct.class, false);
        this.rules = rules;
        if (load) {
            this.load();
        }
    }

    public DocumentAct getLogo(Entity entity) {
        DocumentAct act = this.logos.get(entity.getObjectReference());
        if (act == null) {
            act = this.load(entity);
        }
        return act;
    }

    public void destroy() {
        super.destroy();
        this.logos.clear();
    }

    protected void load() {
        IArchetypeService service = this.getService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DocumentAct.class);
        Root from = query.from(DocumentAct.class, new String[]{"act.documentLogo"});
        Join owner = from.join("owner").join("entity", new String[]{"party.organisationPractice", "party.organisationLocation", "entity.letterhead"});
        owner.on((Expression)builder.equal((Expression)owner.get("active"), (Object)true));
        query.orderBy(new Order[]{builder.desc((Expression)from.get("id"))});
        for (DocumentAct act : service.createQuery(query).getResultList()) {
            this.addObject((IMObject)act);
        }
    }

    protected DocumentAct load(Entity entity) {
        DocumentAct result = null;
        DocumentAct act = this.rules.getLogo(entity);
        if (act != null) {
            result = (DocumentAct)this.addObject((IMObject)act);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void added(DocumentAct object) {
        Reference owner = this.getOwner(object);
        if (owner != null) {
            Map<Reference, DocumentAct> map = this.logos;
            synchronized (map) {
                DocumentAct existing = this.logos.get(owner);
                if (existing == null || object.getId() <= existing.getId()) {
                    this.logos.put(owner, object);
                }
            }
        }
    }

    protected void removed(DocumentAct object) {
        Reference owner = this.getOwner(object);
        if (owner != null) {
            this.logos.remove(owner, object);
        }
    }

    private Reference getOwner(DocumentAct object) {
        IMObjectBean bean = this.getService().getBean((IMObject)object);
        return bean.getTargetRef("owner");
    }
}

