/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.eftpos;

import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.apache.commons.jxpath.ExpressionContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public class EFTPOSFunctions {
    private final ArchetypeService service;
    private static final Policy<SequencedRelationship> RECEIPTS = Policies.newPolicy(SequencedRelationship.class).anyObject().predicate(Predicates.targetIsA((String[])new String[]{"act.EFTPOSReceiptCustomer"})).orderBySequence().build();
    private static final String PRINTER = "printer";

    public EFTPOSFunctions(ArchetypeService service) {
        this.service = service;
    }

    public Iterable<DocumentAct> printableReceipts(ExpressionContext context) {
        return this.printableReceipts(context.getContextNodePointer().getValue());
    }

    public Iterable<DocumentAct> printableReceipts(Object object) {
        object = FunctionHelper.unwrap((Object)object);
        ArrayList<DocumentAct> result = new ArrayList<DocumentAct>();
        if (object instanceof FinancialAct && ((FinancialAct)object).isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            FinancialAct act = (FinancialAct)object;
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Act.class);
            Root root = query.from(Act.class, new String[]{"act.EFTPOSPayment", "act.EFTPOSRefund"});
            query.select((Selection)root);
            Join parentId = root.join("parentId");
            parentId.on((Expression)builder.equal((Expression)parentId.get("identity"), (Object)Long.toString(act.getId())));
            query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
            for (Act transaction : this.service.createQuery(query).getResultList()) {
                IMObjectBean terminalBean;
                IMObjectBean bean = this.service.getBean((IMObject)transaction);
                Entity terminal = (Entity)bean.getTarget("terminal", Entity.class);
                if (terminal == null || !(terminalBean = this.service.getBean((IMObject)terminal)).hasNode(PRINTER) || terminalBean.getBoolean(PRINTER)) continue;
                result.addAll(bean.getTargets("receipts", DocumentAct.class, RECEIPTS));
            }
        }
        return result;
    }
}

