/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.contact;

import javax.persistence.criteria.Expression;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public abstract class ContactFunctions
extends AbstractObjectFunctions {
    private final PartyRules rules;
    private final String archetype;
    private final ArchetypeService service;

    protected ContactFunctions(String namespace, String archetype, PartyRules rules, ArchetypeService service) {
        super(namespace);
        this.rules = rules;
        this.archetype = archetype;
        this.service = service;
        this.setObject((Object)this);
    }

    public Contact preferred(Object object) {
        return this.getContact(this.getParty(object), false, null);
    }

    public Contact billing(Object object) {
        return this.getContact(this.getParty(object), false, "BILLING");
    }

    public Contact correspondence(Object object) {
        return this.getContact(this.getParty(object), false, "CORRESPONDENCE");
    }

    public Contact reminder(Object object) {
        return this.getContact(this.getParty(object), false, "REMINDER");
    }

    public Contact purpose(Object object, String purpose) {
        Party party = this.getParty(object);
        return party != null && purpose != null ? this.getContact(party, true, purpose) : null;
    }

    public abstract String format(Contact var1);

    protected Contact getContact(Party party, boolean exact, String purpose) {
        return party != null ? this.rules.getContact(party, this.archetype, exact, null, purpose) : null;
    }

    protected Party getParty(long id) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Party.class);
        Root root = query.from(Party.class, new String[]{"party.*", "security.user"});
        query.where((Expression)builder.equal((Expression)root.get("id"), (Object)id));
        return (Party)this.service.createQuery(query).getFirstResult();
    }

    protected PartyRules getRules() {
        return this.rules;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private Party getParty(Object object) {
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Party) {
            return (Party)object;
        }
        if (object instanceof Number) {
            return this.getParty(((Number)object).longValue());
        }
        return null;
    }
}

