/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.ScheduleTimes;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;

class ClinicianSchedule {
    private final User clinician;
    private final Date from;
    private final Date to;
    private final IArchetypeService service;
    private final RosterService rosterService;
    private final AppointmentService appointmentService;
    private final AppointmentRules rules;
    private final IMObjectCache areas;
    private List<RosterService.UserEvent> events;
    private RangeSet<Date> appointments;
    private Reference location;

    ClinicianSchedule(User clinician, Date from, Date to, IArchetypeService service, RosterService rosterService, AppointmentService appointmentService, AppointmentRules rules) {
        this.clinician = clinician;
        this.from = from;
        this.to = to;
        this.service = service;
        this.rosterService = rosterService;
        this.appointmentService = appointmentService;
        this.rules = rules;
        this.areas = new SoftRefIMObjectCache((ArchetypeService)service);
    }

    public RangeSet<Date> getShifts(Entity schedule) {
        TreeRangeSet shifts = TreeRangeSet.create();
        Reference newLocation = this.getLocation(schedule);
        if (newLocation != null) {
            if (this.events == null || !Objects.equals(this.location, newLocation)) {
                this.events = this.rosterService.getUserEvents(this.clinician, newLocation, this.from, this.to);
                this.location = newLocation;
            }
            for (RosterService.UserEvent event : this.events) {
                Entity area = (Entity)this.areas.get(event.getArea());
                if (area == null || !this.rules.rosterAreaHasSchedule(area, schedule)) continue;
                Range range = Range.closed((Comparable)event.getStartTime(), (Comparable)event.getEndTime());
                shifts.add(range);
            }
        }
        return shifts;
    }

    public RangeSet<Date> getAppointments() {
        if (this.appointments == null) {
            this.appointments = TreeRangeSet.create();
            List<ScheduleTimes> times = this.appointmentService.getAppointmentsForClinician(this.clinician, this.from, this.to);
            for (Times times2 : times) {
                this.appointments.add(Range.closed((Comparable)times2.getStartTime(), (Comparable)times2.getEndTime()));
            }
        }
        return this.appointments;
    }

    private Reference getLocation(Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        return bean.getTargetRef("location");
    }
}

