/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openvpms.component.business.service.archetype.helper.AbstractIMObjectCopyHandler;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class MappingCopyHandler
extends AbstractIMObjectCopyHandler {
    protected static final String MAP_TO_NULL = "__MAP_TO_NULL";
    private final Types refTypes = new Types();
    private final Types copyTypes = new Types();
    private final Types excludeTypes = new Types();
    private String[][] shortNameMap;
    private boolean reverse;
    private Treatment defaultTreatment = Treatment.COPY;

    protected MappingCopyHandler() {
    }

    protected MappingCopyHandler(String[][] shortNameMap) {
        this.setShortNameMap(shortNameMap);
    }

    protected MappingCopyHandler(String[][] shortNameMap, boolean reverse) {
        this.setShortNameMap(shortNameMap);
        this.setReverse(reverse);
    }

    public void setShortNameMap(String[][] shortNameMap) {
        this.shortNameMap = shortNameMap;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setReference(Class<?> ... types) {
        this.refTypes.setTypes(types);
    }

    public void setReference(String ... shortNames) {
        this.refTypes.setShortNames(shortNames);
    }

    public void setCopy(Class<?> ... types) {
        this.copyTypes.setTypes(types);
    }

    public void setCopy(String ... shortNames) {
        this.copyTypes.setShortNames(shortNames);
    }

    public void setExclude(Class<?> ... types) {
        this.excludeTypes.setTypes(types);
    }

    public void setExclude(String ... shortNames) {
        this.excludeTypes.setShortNames(shortNames);
    }

    public void setDefaultTreatment(Treatment treatment) {
        this.defaultTreatment = treatment;
    }

    public Treatment getDefaultTreatment() {
        return this.defaultTreatment;
    }

    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result;
        String from = object.getArchetype();
        String to = this.mapTo(from);
        if (MAP_TO_NULL.equals(to)) {
            result = null;
        } else if (to != null) {
            result = service.create(to, IMObject.class);
        } else {
            switch (this.getTreatment(object)) {
                case REFERENCE: {
                    result = object;
                    break;
                }
                case COPY: {
                    result = service.create(object.getArchetype(), IMObject.class);
                    break;
                }
                case EXCLUDE: {
                    result = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Object not handled");
                }
            }
        }
        return result;
    }

    protected String mapTo(String shortName) {
        String result = null;
        if (this.shortNameMap != null) {
            for (String[] map : this.shortNameMap) {
                String to;
                String from;
                if (!this.reverse) {
                    from = map[0];
                    to = map[1];
                } else {
                    from = map[1];
                    to = map[0];
                }
                if (!shortName.equals(from)) continue;
                result = to == null ? MAP_TO_NULL : to;
                break;
            }
        }
        return result;
    }

    protected Treatment getTreatment(IMObject object) {
        if (this.exclude(object)) {
            return Treatment.EXCLUDE;
        }
        if (this.reference(object)) {
            return Treatment.REFERENCE;
        }
        if (this.copy(object)) {
            return Treatment.COPY;
        }
        return this.defaultTreatment;
    }

    protected boolean reference(IMObject object) {
        return this.refTypes.matches(object);
    }

    protected boolean copy(IMObject object) {
        return this.copyTypes.matches(object);
    }

    protected boolean exclude(IMObject object) {
        return this.excludeTypes.matches(object);
    }

    private static class Types {
        private Set<Class<?>> types = Collections.emptySet();
        private Set<String> archetypes = Collections.emptySet();

        private Types() {
        }

        public void setTypes(Class<?> ... types) {
            this.types = types.length == 0 ? Collections.emptySet() : new HashSet(Arrays.asList(types));
        }

        public Class<?> matchesType(IMObject object) {
            return this.getMatchingType(object);
        }

        public void setShortNames(String ... shortNames) {
            this.archetypes = shortNames.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(shortNames));
        }

        public boolean matches(IMObject object) {
            String archetype = object.getArchetype();
            return this.archetypes.contains(archetype) || this.isInstance(object);
        }

        private boolean isInstance(IMObject object) {
            for (Class<?> type : this.types) {
                if (!type.isAssignableFrom(object.getClass())) continue;
                return true;
            }
            return false;
        }

        private Class<?> getMatchingType(IMObject object) {
            return this.getMatchingType(object.getClass());
        }

        private Class<?> getMatchingType(Class<?> clazz) {
            Class<?> result = null;
            for (Class<?> type : this.types) {
                if (!type.isAssignableFrom(clazz)) continue;
                if (result != null) {
                    if (!result.isAssignableFrom(type)) continue;
                    result = type;
                    continue;
                }
                result = type;
            }
            return result;
        }
    }

    public static enum Treatment {
        REFERENCE,
        COPY,
        EXCLUDE;

    }
}

