/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.system.common.util.DateHelper;

public class DateRules {
    private DateRules() {
    }

    public static Date getDate(Date startTime, int interval, DateUnits units) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startTime);
        if (units != null) {
            switch (units) {
                case YEARS: {
                    calendar.add(1, interval);
                    break;
                }
                case MONTHS: {
                    calendar.add(2, interval);
                    break;
                }
                case WEEKS: {
                    calendar.add(6, interval * 7);
                    break;
                }
                case DAYS: {
                    calendar.add(6, interval);
                    break;
                }
                case HOURS: {
                    calendar.add(11, interval);
                    break;
                }
                case MINUTES: {
                    calendar.add(12, interval);
                }
            }
        }
        return calendar.getTime();
    }

    public static Date plus(Date date, Period period) {
        return new DateTime((Object)date).plus((ReadablePeriod)period).toDate();
    }

    public static Date minus(Date date, Period period) {
        return new DateTime((Object)date).minus((ReadablePeriod)period).toDate();
    }

    public static Date getToday() {
        return DateRules.getDate(new Date());
    }

    public static Date getTomorrow() {
        return DateRules.getNextDate(DateRules.getToday());
    }

    public static Date getYesterday() {
        return DateRules.getDate(DateRules.getToday(), -1, DateUnits.DAYS);
    }

    public static Date getDate(Date datetime) {
        if (datetime == null) {
            return null;
        }
        return DateUtils.truncate((Date)new Date(datetime.getTime()), (int)5);
    }

    public static Date getNextDate(Date datetime) {
        if (datetime == null) {
            return null;
        }
        return DateRules.getDate(DateRules.getDate(datetime), 1, DateUnits.DAYS);
    }

    public static Date getPreviousDate(Date datetime) {
        if (datetime == null) {
            return null;
        }
        return DateRules.getDate(DateRules.getDate(datetime), -1, DateUnits.DAYS);
    }

    public static Date getMonthStart(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getMonthEnd(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        ((Calendar)calendar).add(2, 1);
        ((Calendar)calendar).add(5, -1);
        return calendar.getTime();
    }

    public static int getDaysInMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static int compareTo(Date lhs, Date rhs) {
        return DateRules.compareDateTime(lhs, rhs, true);
    }

    public static int compareTo(Date lhs, Date rhs, boolean ignoreMillis) {
        if (ignoreMillis) {
            lhs = lhs != null ? DateUtils.truncate((Date)new Date(lhs.getTime()), (int)13) : null;
            rhs = rhs != null ? DateUtils.truncate((Date)new Date(rhs.getTime()), (int)13) : null;
        }
        return DateRules.compareTo(lhs, rhs);
    }

    public static boolean intersects(Date from1, Date to1, Date from2, Date to2) {
        return DateHelper.intersects((Date)from1, (Date)to1, (Date)from2, (Date)to2);
    }

    public static boolean between(Date date, Date lowerBound, Date upperBound) {
        return DateHelper.between((Date)date, (Date)lowerBound, (Date)upperBound);
    }

    public static boolean betweenDates(Date date, Date from, Date to) {
        date = DateRules.getDate(date);
        from = DateRules.getDate(from);
        to = DateRules.getDate(to);
        return !(from != null && DateRules.compareTo(from, date) > 0 || to != null && DateRules.compareTo(to, date) <= 0);
    }

    public static Date addDateTime(Date date, Date time) {
        GregorianCalendar dateCal = new GregorianCalendar();
        dateCal.setTime(date);
        GregorianCalendar timeCal = new GregorianCalendar();
        timeCal.setTime(time);
        dateCal.set(11, timeCal.get(11));
        dateCal.set(12, timeCal.get(12));
        dateCal.set(13, timeCal.get(13));
        return dateCal.getTime();
    }

    public static int compareDates(Date d1, Date d2) {
        return DateRules.compareDate(d1, d2, true);
    }

    public static int compareDate(Date d1, Date d2, boolean nullHigh) {
        d1 = DateRules.getDate(d1);
        d2 = DateRules.getDate(d2);
        return DateRules.compareDateTime(d1, d2, nullHigh);
    }

    public static int compareDateTime(Date d1, Date d2, boolean nullHigh) {
        return DateHelper.compareTo((Date)d1, (Date)d2, (boolean)nullHigh);
    }

    public static int compareDateToToday(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Argument 'date' is required");
        }
        return DateRules.getDate(date).compareTo(DateRules.getToday());
    }

    public static boolean dateEquals(Date date1, Date date2) {
        boolean result = date1 == null || date2 == null ? date1 == null && date2 == null : DateRules.compareDates(date1, date2) == 0;
        return result;
    }

    public static Date min(Date date1, Date date2) {
        return DateRules.compareTo(date1, date2) < 0 ? date1 : date2;
    }

    public static Date max(Date date1, Date date2) {
        return DateRules.compareTo(date1, date2) > 0 ? date1 : date2;
    }

    public static LocalDate toLocalDate(Date date) {
        return date != null ? date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date != null ? date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    public static OffsetDateTime toOffsetDateTime(Date date) {
        return date != null ? OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()) : null;
    }

    public static Date toDate(LocalDate date) {
        return date != null ? Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static Date toDate(OffsetDateTime date) {
        return date != null ? Date.from(date.toInstant()) : null;
    }

    public static boolean isToday(Date date) {
        return DateRules.compareDateToToday(date) == 0;
    }

    public static boolean isYesterday(Date date) {
        return DateRules.getDate(date).compareTo(DateRules.getYesterday()) == 0;
    }

    public static boolean isToday(OffsetDateTime date) {
        return date.withOffsetSameInstant(OffsetDateTime.now().getOffset()).toLocalDate().equals(LocalDate.now());
    }

    public static boolean isTomorrow(OffsetDateTime date) {
        return date.withOffsetSameInstant(OffsetDateTime.now().getOffset()).toLocalDate().equals(LocalDate.now().plusDays(1L));
    }

    public static int minutesBetween(Date from, Date to) {
        return Minutes.minutesBetween((ReadableInstant)new DateTime((Object)from), (ReadableInstant)new DateTime((Object)to)).getMinutes();
    }
}

