/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openvpms.archetype.i18n.ArchetypeMessages;
import org.openvpms.archetype.rules.user.PasswordPolicy;

public class PasswordValidator {
    private final PasswordPolicy policy;
    private final Pattern specialPattern;
    private final Pattern invalidPattern;
    private static final Pattern LOWER_PATTERN = Pattern.compile("[a-z]");
    private static final Pattern UPPER_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]");

    public PasswordValidator(PasswordPolicy policy) {
        this.policy = policy;
        this.specialPattern = Pattern.compile("[" + policy.getSpecialCharactersEscaped() + "]");
        this.invalidPattern = Pattern.compile("[^" + policy.getValidCharactersEscaped() + "]");
    }

    public List<String> validate(String password) {
        Matcher matcher;
        ArrayList<String> errors = new ArrayList<String>();
        int minLength = this.policy.getMinLength();
        if (password.matches(".*\\s.*")) {
            errors.add(ArchetypeMessages.passwordCannotContainWhitespace());
        }
        if (password.length() < minLength) {
            errors.add(ArchetypeMessages.passwordLessThanMinimumLength(minLength));
        } else {
            int maxLength = this.policy.getMaxLength();
            if (password.length() > maxLength) {
                errors.add(ArchetypeMessages.passwordGreaterThanMaximumLength(maxLength));
            }
        }
        if (this.policy.lowercaseRequired() && this.noMatch(password, LOWER_PATTERN)) {
            errors.add(ArchetypeMessages.passwordMustContainLowercaseCharacter());
        }
        if (this.policy.uppercaseRequired() && this.noMatch(password, UPPER_PATTERN)) {
            errors.add(ArchetypeMessages.passwordMustContainUppercaseCharacter());
        }
        if (this.policy.numberRequired() && this.noMatch(password, NUMBER_PATTERN)) {
            errors.add(ArchetypeMessages.passwordMustContainNumber());
        }
        if (this.policy.specialRequired() && this.noMatch(password, this.specialPattern)) {
            errors.add(ArchetypeMessages.passwordMustContainSpecialCharacter());
        }
        if (errors.isEmpty() && (matcher = this.invalidPattern.matcher(password)).find()) {
            errors.add(ArchetypeMessages.passwordCharacterInvalid(matcher.group(0).charAt(0)));
        }
        return errors;
    }

    private boolean noMatch(String password, Pattern pattern) {
        return !pattern.matcher(password).find();
    }
}

