/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;

public class ChargeStockUpdater {
    private final IArchetypeService service;
    private final StockRules rules;
    private final Set<IMObject> toSave = new LinkedHashSet<IMObject>();

    public ChargeStockUpdater(IArchetypeService service) {
        this.service = service;
        this.rules = new StockRules(service);
    }

    public void update(FinancialAct act) {
        try {
            this.updateChargeItem(act);
            if (!this.toSave.isEmpty()) {
                this.service.save(this.toSave);
            }
        }
        finally {
            this.toSave.clear();
        }
    }

    public void remove(FinancialAct act) {
        try {
            if (TypeHelper.isA((IMObject)act, (String[])new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter", "act.customerAccountChargesCredit"})) {
                this.removeCharge(act);
            } else {
                this.removeChargeItem(act);
            }
            if (!this.toSave.isEmpty()) {
                this.service.save(this.toSave);
            }
        }
        finally {
            this.toSave.clear();
        }
    }

    private void updateChargeItem(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        boolean credit = bean.isA(new String[]{"act.customerAccountCreditItem"});
        StockQty current = new StockQty(bean);
        StockQty prior = this.getSavedStockQty(act);
        BigDecimal priorQty = BigDecimal.ZERO;
        if (prior != null && prior.isValid()) {
            priorQty = prior.getQuantity();
            if (!prior.hasProduct(current)) {
                this.updateStockQuantities(prior, priorQty.negate(), credit);
                priorQty = BigDecimal.ZERO;
            }
        }
        BigDecimal quantity = current.getQuantity();
        if (current.isValid()) {
            if (!MathRules.equals(quantity, priorQty)) {
                BigDecimal diff = quantity.subtract(priorQty);
                this.updateStockQuantities(current, diff, credit);
            }
        } else {
            bean.removeValues("stockLocation");
        }
    }

    private void updateStockQuantities(StockQty stock, BigDecimal quantity, boolean credit) {
        Reference location = stock.getLocation();
        Product product = stock.getProduct();
        if (location != null && TypeHelper.isA((IMObject)product, (String[])new String[]{"product.medication", "product.merchandise"})) {
            IMObjectRelationship relationship;
            if (!credit) {
                quantity = quantity.negate();
            }
            if ((relationship = this.rules.getStockRelationship(product, location)) == null) {
                List<IMObject> objects = this.rules.calcStock(product, location, quantity);
                this.toSave.addAll(objects);
            } else {
                this.rules.calcStock((Relationship)relationship, quantity);
                this.toSave.add((IMObject)relationship);
            }
        }
    }

    private void removeCharge(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        for (FinancialAct item : bean.getTargets("items", FinancialAct.class)) {
            this.removeChargeItem(item);
        }
    }

    private void removeChargeItem(FinancialAct act) {
        IMObjectBean bean;
        StockQty stockQty;
        if (!act.isNew() && (stockQty = new StockQty(bean = this.service.getBean((IMObject)act))).isValid()) {
            boolean credit = bean.isA(new String[]{"act.customerAccountCreditItem"});
            BigDecimal quantity = stockQty.getQuantity();
            this.updateStockQuantities(stockQty, quantity.negate(), credit);
        }
    }

    private StockQty getSavedStockQty(FinancialAct act) {
        FinancialAct result = (FinancialAct)this.get(act.getObjectReference());
        return result != null ? new StockQty(result) : null;
    }

    private IMObject get(Reference ref) {
        return ref != null ? this.service.get(ref) : null;
    }

    private class StockQty {
        private final Reference location;
        private final Reference product;
        private final BigDecimal quantity;

        public StockQty(FinancialAct act) {
            this(chargeStockUpdater.service.getBean((IMObject)act));
        }

        public StockQty(IMObjectBean bean) {
            this.product = bean.getTargetRef("product");
            this.location = bean.getTargetRef("stockLocation");
            this.quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
        }

        public Reference getProductRef() {
            return this.product;
        }

        public Product getProduct() {
            return (Product)ChargeStockUpdater.this.get(this.product);
        }

        public Reference getLocation() {
            return this.location;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public boolean isValid() {
            return this.product != null && this.location != null;
        }

        public boolean hasProduct(StockQty other) {
            return Objects.equals(this.product, other.getProductRef());
        }
    }
}

