/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

class ProductIOHelper {
    private ProductIOHelper() {
    }

    public static ProductPrice getPrice(PriceData data, List<ProductPrice> prices) {
        long id = data.getId();
        for (ProductPrice price : prices) {
            if (price.getId() != id) continue;
            return price;
        }
        throw new ProductIOException(ProductIOException.ErrorCode.PriceNotFound, data.getLine(), id);
    }

    public static boolean isDefault(IMObjectBean bean) {
        return bean.hasNode("default") && bean.getBoolean("default");
    }

    public static String[] getPricingGroupCodes(ProductPrice price, IArchetypeService service) {
        List<Lookup> groups = ProductIOHelper.getPricingGroupList(price, (ArchetypeService)service);
        Object[] codes = new String[groups.size()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = groups.get(i).getCode();
        }
        Arrays.sort(codes);
        return codes;
    }

    public static Set<Lookup> getPricingGroups(ProductPrice price, ArchetypeService service) {
        return new HashSet<Lookup>(ProductIOHelper.getPricingGroupList(price, service));
    }

    public static boolean intersects(PriceData price1, PriceData price2) {
        return DateRules.intersects(price1.getFrom(), price1.getTo(), price2.getFrom(), price2.getTo()) && ProductIOHelper.groupsIntersect(price1, price2);
    }

    public static boolean intersects(PriceData price1, ProductPrice price2, ArchetypeService service) {
        return DateRules.intersects(price2.getFromDate(), price2.getToDate(), price1.getFrom(), price1.getTo()) && ProductIOHelper.groupsIntersect(price1, price2, service);
    }

    public static boolean groupsIntersect(PriceData price1, ProductPrice price2, ArchetypeService service) {
        return ProductIOHelper.intersects(price1.getPricingGroups(), ProductIOHelper.getPricingGroups(price2, service), false);
    }

    public static boolean groupsIntersect(PriceData price1, PriceData price2) {
        return ProductIOHelper.intersects(price1.getPricingGroups(), price2.getPricingGroups(), true);
    }

    private static List<Lookup> getPricingGroupList(ProductPrice price, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)price);
        return bean.getValues("pricingGroups", Lookup.class);
    }

    private static boolean intersects(Set<Lookup> group1, Set<Lookup> group2, boolean copy2) {
        if (group1.equals(group2)) {
            return true;
        }
        if (copy2) {
            group2 = new HashSet<Lookup>(group2);
        }
        group2.retainAll(group1);
        return !group2.isEmpty();
    }
}

