/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.product.io.ProductIOHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductDataComparator {
    private final ProductPriceRules rules;
    private final ArchetypeService service;

    public ProductDataComparator(ProductPriceRules rules, ArchetypeService service) {
        this.rules = rules;
        this.service = service;
    }

    public ProductData compare(Product product, ProductData data) {
        boolean printedNameChanged;
        List<ProductPrice> fixedPrices = this.getFixedPrices(product, data);
        List<ProductPrice> unitPrices = this.getUnitPrices(product, data);
        this.validate(product, data, fixedPrices, unitPrices);
        ProductData result = null;
        List<PriceData> fixedPriceData = this.getPriceChanges(product, data.getFixedPrices(), fixedPrices);
        List<PriceData> unitPriceData = this.getPriceChanges(product, data.getUnitPrices(), unitPrices);
        IMObjectBean bean = this.service.getBean((IMObject)product);
        boolean bl = printedNameChanged = !Objects.equals(data.getPrintedName(), bean.getString("printedName"));
        if (!fixedPriceData.isEmpty() || !unitPriceData.isEmpty() || printedNameChanged) {
            result = new ProductData(data);
            result.setReference(product.getObjectReference());
            result.setPrintedName(data.getPrintedName());
            result.getFixedPrices().addAll(fixedPriceData);
            result.getUnitPrices().addAll(unitPriceData);
        }
        return result;
    }

    public List<ProductPrice> getFixedPrices(Product product, ProductData data) {
        return this.getPrices(product, data, true);
    }

    public List<ProductPrice> getUnitPrices(Product product, ProductData data) {
        return this.getPrices(product, data, false);
    }

    private List<ProductPrice> getPrices(Product product, ProductData data, boolean fixed) {
        List<PriceData> prices;
        List<PriceData> list = prices = fixed ? data.getFixedPrices() : data.getUnitPrices();
        List<ProductPrice> result = prices.isEmpty() ? Collections.emptyList() : this.rules.getProductPrices(product, fixed ? "productPrice.fixedPrice" : "productPrice.unitPrice", PricingGroup.ALL);
        return result;
    }

    private void validate(Product product, ProductData data, List<ProductPrice> fixedPrices, List<ProductPrice> unitPrices) {
        this.checkPrices(product, data.getUnitPrices(), unitPrices);
        this.checkPrices(product, data.getFixedPrices(), fixedPrices);
    }

    private void checkPrices(Product product, List<PriceData> prices, List<ProductPrice> existing) {
        for (PriceData price : prices) {
            if (price.getFrom() == null) {
                throw new ProductIOException(ProductIOException.ErrorCode.NoFromDate, price.getLine(), new Object[0]);
            }
            if (price.getId() == -1L) continue;
            this.checkPrice(price, product, existing);
        }
    }

    private void checkPrice(PriceData price, Product product, List<ProductPrice> existing) {
        boolean found = false;
        for (ProductPrice pp : existing) {
            if (pp.getId() != price.getId()) continue;
            if (pp.getProduct().getId() != product.getId() && !this.equals(price, pp)) {
                throw new ProductIOException(ProductIOException.ErrorCode.CannotUpdateLinkedPrice, price.getLine(), price.getId(), product.getName(), product.getId(), pp.getProduct().getName(), pp.getProduct().getId());
            }
            found = true;
            break;
        }
        if (!found) {
            throw new ProductIOException(ProductIOException.ErrorCode.PriceNotFound, price.getLine(), price.getId());
        }
    }

    private List<PriceData> getPriceChanges(Product product, List<PriceData> prices, List<ProductPrice> existing) {
        ArrayList<PriceData> result = new ArrayList<PriceData>();
        List<PriceData> duplicateFree = this.removeDuplicates(prices, existing);
        Date from = null;
        boolean sameFromDate = true;
        for (PriceData price : duplicateFree) {
            if (price.getId() != -1L) {
                PriceData data = this.getUpdatedPriceData(product, price, existing);
                if (data == null) continue;
                result.add(data);
                continue;
            }
            if (from == null) {
                from = price.getFrom();
                continue;
            }
            if (price.getFrom() == null || DateRules.dateEquals(from, price.getFrom())) continue;
            sameFromDate = false;
        }
        List<PriceData> merged = this.merge(result, existing);
        this.checkOverlap(merged);
        this.getNewPriceChanges(duplicateFree, merged, result, product, sameFromDate);
        return result;
    }

    private void getNewPriceChanges(List<PriceData> prices, List<PriceData> existing, List<PriceData> changed, Product product, boolean sameFrom) {
        for (PriceData price : prices) {
            if (price.getId() != -1L || !this.updateExistingPrice(price, existing, changed, product, sameFrom)) continue;
            changed.add(price);
        }
    }

    private List<PriceData> removeDuplicates(List<PriceData> prices, List<ProductPrice> current) {
        List<PriceData> unique;
        ArrayList<PriceData> result = new ArrayList<PriceData>();
        if (prices.size() <= 1) {
            unique = prices;
        } else {
            PriceData existing;
            unique = new ArrayList<PriceData>();
            HashMap<Long, PriceData> dataById = new HashMap<Long, PriceData>();
            LinkedHashMap<DateRangePricingGroup, PriceData> dataByDate = new LinkedHashMap<DateRangePricingGroup, PriceData>();
            for (PriceData data : prices) {
                if (data.getId() == -1L) continue;
                existing = (PriceData)dataById.get(data.getId());
                if (existing != null) {
                    if (!data.equals(existing)) {
                        if ("productPrice.fixedPrice".equals(data.getShortName())) {
                            throw new ProductIOException(ProductIOException.ErrorCode.DuplicateFixedPrice, data.getLine(), new Object[0]);
                        }
                        throw new ProductIOException(ProductIOException.ErrorCode.DuplicateUnitPrice, data.getLine(), new Object[0]);
                    }
                } else {
                    dataById.put(data.getId(), data);
                    DateRangePricingGroup key = new DateRangePricingGroup(data);
                    if (dataByDate.get(key) != null) {
                        if ("productPrice.unitPrice".equals(data.getShortName())) {
                            throw new ProductIOException(ProductIOException.ErrorCode.DuplicateUnitPrice, data.getLine(), new Object[0]);
                        }
                    } else {
                        dataByDate.put(key, data);
                    }
                }
                unique.add(data);
            }
            for (PriceData data : prices) {
                if (data.getId() != -1L) continue;
                existing = (PriceData)dataByDate.get(new DateRangePricingGroup(data));
                if (existing != null) {
                    if (this.priceEquals(data, existing)) continue;
                    if ("productPrice.unitPrice".equals(data.getShortName())) {
                        throw new ProductIOException(ProductIOException.ErrorCode.DuplicateUnitPrice, data.getLine(), new Object[0]);
                    }
                    unique.add(data);
                    continue;
                }
                dataByDate.put(new DateRangePricingGroup(data), data);
                unique.add(data);
            }
        }
        for (PriceData data : unique) {
            boolean found = false;
            for (ProductPrice price : current) {
                if (!this.equals(data, price)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(data);
        }
        return result;
    }

    private PriceData getUpdatedPriceData(Product product, PriceData price, List<ProductPrice> prices) {
        PriceData result = null;
        ProductPrice existing = ProductIOHelper.getPrice(price, prices);
        if (this.isLinkedPrice(existing, product)) {
            if (!this.equals(price, existing)) {
                throw new ProductIOException(ProductIOException.ErrorCode.CannotUpdateLinkedPrice, price.getLine(), new Object[0]);
            }
        } else if (!this.equals(price, existing)) {
            result = price;
        }
        return result;
    }

    private boolean isLinkedPrice(ProductPrice price, Product product) {
        Product priceProduct = price.getProduct();
        return !Objects.equals(priceProduct, product);
    }

    private boolean isLinkedPrice(PriceData price, Product product) {
        for (ProductPrice productPrice : product.getProductPrices()) {
            if (productPrice.getId() != price.getId()) continue;
            return false;
        }
        return true;
    }

    private void checkOverlap(List<PriceData> prices) {
        for (PriceData price : prices) {
            if (!"productPrice.unitPrice".equals(price.getShortName())) continue;
            this.checkOverlap(price, prices);
        }
    }

    private void checkOverlap(PriceData price, List<PriceData> prices) {
        for (PriceData p : prices) {
            if (p.getId() == price.getId() || !ProductIOHelper.intersects(price, p)) continue;
            throw new ProductIOException(ProductIOException.ErrorCode.UnitPriceOverlap, price.getLine(), new Object[0]);
        }
    }

    private boolean updateExistingPrice(PriceData newPrice, List<PriceData> prices, List<PriceData> changed, Product product, boolean sameFrom) {
        boolean create;
        PriceData existing = this.getIntersectMatch(newPrice, prices);
        if (existing == null) {
            create = true;
        } else {
            boolean dateMatch = this.dateEquals(newPrice, existing);
            boolean priceMatch = this.priceEquals(newPrice, existing);
            if (dateMatch && priceMatch) {
                create = false;
            } else {
                if (this.isLinkedPrice(existing, product)) {
                    existing = null;
                } else if ("productPrice.unitPrice".equals(newPrice.getShortName()) && (dateMatch || existing.getTo() != null)) {
                    throw new ProductIOException(ProductIOException.ErrorCode.UnitPriceOverlap, newPrice.getLine(), new Object[0]);
                }
                create = true;
            }
        }
        if (create) {
            Date from = newPrice.getFrom();
            if (existing != null && existing.getTo() == null) {
                if (!sameFrom) {
                    throw new ProductIOException(ProductIOException.ErrorCode.CannotCloseExistingPrice, newPrice.getLine(), new Object[0]);
                }
                existing.setTo(from);
                if (!changed.contains(existing)) {
                    changed.add(existing);
                }
            }
        }
        return create;
    }

    private List<PriceData> merge(List<PriceData> updated, List<ProductPrice> existing) {
        ArrayList<PriceData> result = new ArrayList<PriceData>();
        for (ProductPrice productPrice : existing) {
            PriceData found = null;
            for (PriceData data : updated) {
                if (data.getId() != productPrice.getId()) continue;
                found = data;
                break;
            }
            if (found != null) {
                result.add(found);
                continue;
            }
            result.add(new PriceData(productPrice, this.service));
        }
        return result;
    }

    private boolean equals(PriceData data, ProductPrice price) {
        return this.priceEquals(data, price) && this.dateEquals(data, price);
    }

    private boolean dateEquals(PriceData data, ProductPrice price) {
        return DateRules.dateEquals(data.getFrom(), price.getFromDate()) && DateRules.dateEquals(data.getTo(), price.getToDate());
    }

    private boolean dateEquals(PriceData data1, PriceData data2) {
        return DateRules.dateEquals(data1.getFrom(), data2.getFrom()) && DateRules.dateEquals(data1.getTo(), data2.getTo());
    }

    private boolean priceEquals(PriceData data1, PriceData data2) {
        return data2.getPrice().compareTo(data1.getPrice()) == 0 && data2.getCost().compareTo(data1.getCost()) == 0 && data2.getMaxDiscount().compareTo(data1.getMaxDiscount()) == 0 && (!"productPrice.fixedPrice".equals(data1.getShortName()) || data1.isDefault() == data2.isDefault());
    }

    private boolean priceEquals(PriceData data, ProductPrice price) {
        IMObjectBean bean = this.service.getBean((IMObject)price);
        BigDecimal cost = bean.getBigDecimal("cost", BigDecimal.ZERO);
        BigDecimal maxDiscount = bean.getBigDecimal("maxDiscount", BigDecimal.ZERO);
        if (!(price.getPrice().compareTo(data.getPrice()) != 0 || cost.compareTo(data.getCost()) != 0 || maxDiscount.compareTo(data.getMaxDiscount()) != 0 || "productPrice.fixedPrice".equals(data.getShortName()) && data.isDefault() != ProductIOHelper.isDefault(bean))) {
            Set<Lookup> pricingGroups = ProductIOHelper.getPricingGroups(price, this.service);
            return pricingGroups.equals(data.getPricingGroups());
        }
        return false;
    }

    private PriceData getIntersectMatch(PriceData price, List<PriceData> prices) {
        ArrayList<PriceData> matches = new ArrayList<PriceData>();
        for (PriceData other : prices) {
            if (other.getId() == price.getId() || !ProductIOHelper.intersects(price, other)) continue;
            matches.add(other);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (PriceData)matches.get(0);
        }
        if ("productPrice.unitPrice".equals(price.getShortName())) {
            throw new ProductIOException(ProductIOException.ErrorCode.UnitPriceOverlap, price.getLine(), new Object[0]);
        }
        return null;
    }

    private static final class DateRangePricingGroup {
        private final Date from;
        private final Date to;
        private final Set<Lookup> groups;

        private DateRangePricingGroup(PriceData data) {
            this.from = DateRules.getDate(data.getFrom());
            this.to = DateRules.getDate(data.getTo());
            this.groups = data.getPricingGroups();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DateRangePricingGroup) {
                DateRangePricingGroup other = (DateRangePricingGroup)obj;
                return DateRules.compareTo(this.from, other.from) == 0 && DateRules.compareTo(this.to, other.to) == 0 && this.groups.equals(other.groups);
            }
            return false;
        }

        public int hashCode() {
            int fromHash = this.from != null ? this.from.hashCode() : 0;
            int toHash = this.to != null ? this.to.hashCode() : 0;
            return fromHash ^ toHash;
        }
    }
}

