/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.product.io.ProductIOHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PriceData {
    private final long id;
    private final String shortName;
    private final int line;
    private BigDecimal price;
    private BigDecimal cost;
    private BigDecimal maxDiscount;
    private Date from;
    private Date to;
    private boolean defaultPrice;
    private Set<Lookup> pricingGroups;

    public PriceData(long id, String shortName, BigDecimal price, BigDecimal cost, BigDecimal maxDiscount, Date from, Date to, Set<Lookup> pricingGroups, int line) {
        this(id, shortName, price, cost, maxDiscount, from, to, false, pricingGroups, line);
    }

    public PriceData(long id, String shortName, BigDecimal price, BigDecimal cost, BigDecimal maxDiscount, Date from, Date to, boolean defaultPrice, Set<Lookup> pricingGroups, int line) {
        this.id = id;
        this.shortName = shortName;
        this.price = price;
        this.cost = cost;
        this.maxDiscount = maxDiscount;
        this.from = from;
        this.to = to;
        this.defaultPrice = defaultPrice;
        this.pricingGroups = pricingGroups;
        this.line = line;
    }

    public PriceData(ProductPrice source, ArchetypeService service) {
        this.id = source.getId();
        this.shortName = source.getArchetype();
        this.price = source.getPrice();
        IMObjectBean bean = service.getBean((IMObject)source);
        this.cost = bean.getBigDecimal("cost", BigDecimal.ZERO);
        this.maxDiscount = bean.getBigDecimal("maxDiscount", BigDecimal.ZERO);
        this.from = source.getFromDate();
        this.to = source.getToDate();
        this.defaultPrice = ProductIOHelper.isDefault(bean);
        this.pricingGroups = ProductIOHelper.getPricingGroups(source, service);
        this.line = -1;
    }

    public long getId() {
        return this.id;
    }

    public String getShortName() {
        return this.shortName;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getMaxDiscount() {
        return this.maxDiscount;
    }

    public void setMaxDiscount(BigDecimal maxDiscount) {
        this.maxDiscount = maxDiscount;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean isDefault() {
        return this.defaultPrice;
    }

    public void setDefault(boolean defaultPrice) {
        this.defaultPrice = defaultPrice;
    }

    public Set<Lookup> getPricingGroups() {
        return this.pricingGroups;
    }

    public void setPricingGroups(Set<Lookup> pricingGroups) {
        this.pricingGroups = pricingGroups;
    }

    public int getLine() {
        return this.line;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PriceData) {
            PriceData o = (PriceData)obj;
            return this.id == o.id && this.shortName.equals(o.shortName) && this.price.compareTo(o.price) == 0 && this.cost.compareTo(o.cost) == 0 && Objects.equals(this.from, o.from) && Objects.equals(this.to, o.to) && (!"productPrice.fixedPrice".equals(this.shortName) || this.defaultPrice == o.isDefault());
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id ^ this.shortName.hashCode() ^ this.price.hashCode() ^ this.cost.hashCode();
    }
}

